#!/usr/bin/perl -w
# -*- Mode: perl; indent-tabs-mode: nil -*-
#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation. Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s):         Brian Bober <boberb@rpi.edu>
#			  Terry Weissman <terry@mozilla.org>
#			  Tara Hernandez <tara@tequilarista.org>

use vars %::FORM;

use diagnostics;
use strict;

require "CGI.pl";

ConnectToDatabase();
GetVersionTable();

print "Content-type: text/html; charset=EUC-JP\n\n";

my $product = $::FORM{'product'};

PutHeader("Bugzilla ڡإ","إ", "եλȤؤ֥ڡǤ");





print qq{

<br>

<form action="none"> <!-- Cause NS4.x is stupid. Die NS4.x you eeeevil eeeevil program! -->

<a name="top"></a>

<p><center><b><font size="+2">Bugzilla θեѤ뤿Υإ</font></b><br>2001ǯ120 - 
<a href="mailto:netdemonz\@yahoo.com">Brian Bober (netdemon)</a>.  
<BR><I>Further heavy mutiliations by <a href="mailto:tara\@tequilarista.org">Tara Heranandez</A>, April 20, 2001.</I></CENTER>

<br><center><img width="329" height="220" src="ant.jpg" border="2" alt="Da Ant"></center>

<p><br><center><h3>Ω</h3></center>

<p>ڡϼΤ褦ʥʬ:

<p><a href="#bugsettings">Х(Bug Settings)</a> 
<br><a href="#peopleinvolved">ط(People Involved)</a> 
<br><a href="#textsearch">ƥȥΥץ(Text Search Options)</a>
<br><a href="#moduleoptions">⥸塼륪ץ(Module Options)</a> 
<br><a href="#advancedquerying">٤ʥ꡼(Advanced Querying)</a>
<br><a href="#therest">եκǲ(The Bottom Of The Form)</a>

<p>&quot;
錄Ϥ⤦ <a href="http://www.mozilla.org/bugs/">Bugzilla</a> λȤΤäƤޤBugzillaȤΥɥȤɮԤ˴ؤ<a href="#info"></a>Τꤿ
&quot;<br>&quot;OK
ɤ䤬ĤХ Bugzilla ̵褦
ǤϡɤΤ褦˥Х <a href="enter_bug.cgi"></a>
٤?  &quot; - <a href= "docs/html/Bugzilla-Guide.html#BUG_WRITING">
ޤϥɥ饤ɤ⤦</a>!

<p><br><center><h3>(Tips)</h3></center> ڡΤ٤Ƥ
եɤɬפϤʤեɤ˵뤳ȤϤʤõʪ
¤롣㤨 Status Τ褦ʥꥹȥܥåǤϡCtrl򲡤ʤ
å뤳Ȥǡץ뤳Ȥ롣ʤ
ʤޤǤϡñʥ꡼ĹХꥹȤʬõ롢
"brute force" ˡȤȤ롣¾οͤθ®٤㲼ʤˡ
ˡȤ뤳ȤϤʤ褦ˤƤۤ⤷ȡ
¿οͤƱ˸ԤäƤ뤫⤷ʤǽŪˤϡ
Ϥ Boolean Chart ˤĤƳؤ֤Ȥ򤪤᤹롣ϤȤƤ⶯Ϥ
ޤۤȤɤ Bugzilla Υڡ<a href="#bottom">ǲ</a>ˤϡ
ʥӥСꡢ<a href="./">եȥڡ</a>
פʥ󥯤ޤǤ롣

<p><a href="query.cgi"></a>. 
⤷˥եˤʤˤ񤭹ǤΤʤ顢
֥饦ǥХåܥ򲡤ȹͤƤ뤫Τʤ
⤷ɤ߽Ȥˤϡ<a href="#samplequery">ץθ</a>
¹ԤƤߤߤ!

};





print qq{

<a name="bugsettings"></a>

<p><br><center><h3>Х(Bug Settings)</h3></center>

<center>

<table width="700" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="200">
<table cellspacing="0">
<tr>
<th align="left"><A HREF="queryhelp.cgi#status">Status</a>:</th>
<th align="left"><A HREF="queryhelp.cgi#resolution">Resolution</a>:</th>
<th align="left"><A HREF="queryhelp.cgi#platform">Platform</a>:</th>
<th align="left"><A HREF="queryhelp.cgi#opsys">OpSys</a>:</th>
<th align="left"><A HREF="queryhelp.cgi#priority">Priority</a>:</th>
<th align="left"><A HREF="queryhelp.cgi#severity">Severity</a>:</th>
</tr>
<tr>
<td align="left" valign="top">

<SELECT NAME="bug_status" MULTIPLE SIZE="7">
<OPTION VALUE="UNCONFIRMED">UNCONFIRMED<OPTION VALUE="NEW">NEW<OPTION VALUE="ASSIGNED">ASSIGNED<OPTION VALUE="REOPENED">REOPENED<OPTION VALUE="RESOLVED">RESOLVED<OPTION VALUE="VERIFIED">VERIFIED<OPTION VALUE="CLOSED">CLOSED</SELECT>

</td>
<td align="left" valign="top">
<SELECT NAME="resolution" MULTIPLE SIZE="7">
<OPTION VALUE="FIXED">FIXED<OPTION VALUE="INVALID">INVALID<OPTION VALUE="WONTFIX">WONTFIX<OPTION VALUE="LATER">LATER<OPTION VALUE="REMIND">REMIND<OPTION VALUE="DUPLICATE">DUPLICATE<OPTION VALUE="WORKSFORME">WORKSFORME<OPTION VALUE="MOVED">MOVED<OPTION VALUE="---">---</SELECT>

</td>
<td align="left" valign="top">
<SELECT NAME="rep_platform" MULTIPLE SIZE="7">
<OPTION VALUE="All">All<OPTION VALUE="DEC">DEC<OPTION VALUE="HP">HP<OPTION VALUE="Macintosh">Macintosh<OPTION VALUE="PC">PC<OPTION VALUE="SGI">SGI<OPTION VALUE="Sun">Sun<OPTION VALUE="Other">Other</SELECT>

</td>
<td align="left" valign="top">
<SELECT NAME="op_sys" MULTIPLE SIZE="7">
<OPTION VALUE="All">All<OPTION VALUE="Windows 3.1">Windows 3.1<OPTION VALUE="Windows 95">Windows 95<OPTION VALUE="Windows 98">Windows 98<OPTION VALUE="Windows ME">Windows ME<OPTION VALUE="Windows 2000">Windows 2000<OPTION VALUE="Windows NT">Windows NT<OPTION VALUE="Mac System 7">Mac System 7<OPTION VALUE="Mac System 7.5">Mac System 7.5<OPTION VALUE="Mac System 7.6.1">Mac System 7.6.1<OPTION VALUE="Mac System 8.0">Mac System 8.0<OPTION VALUE="Mac System 8.5">Mac System 8.5<OPTION VALUE="Mac System 8.6">Mac System 8.6<OPTION VALUE="Mac System 9.0">Mac System 9.0<OPTION VALUE="Linux">Linux<OPTION VALUE="BSDI">BSDI<OPTION VALUE="FreeBSD">FreeBSD<OPTION VALUE="NetBSD">NetBSD<OPTION VALUE="OpenBSD">OpenBSD<OPTION VALUE="AIX">AIX<OPTION VALUE="BeOS">BeOS<OPTION VALUE="HP-UX">HP-UX<OPTION VALUE="IRIX">IRIX<OPTION VALUE="Neutrino">Neutrino<OPTION VALUE="OpenVMS">OpenVMS<OPTION VALUE="OS/2">OS/2<OPTION VALUE="OSF/1">OSF/1<OPTION VALUE="Solaris">Solaris<OPTION VALUE="SunOS">SunOS<OPTION VALUE="other">other</SELECT>

</td>
<td align="left" valign="top">
<SELECT NAME="priority" MULTIPLE SIZE="7">
<OPTION VALUE="P1">P1<OPTION VALUE="P2">P2<OPTION VALUE="P3">P3<OPTION VALUE="P4">P4<OPTION VALUE="P5">P5</SELECT>

</td>
<td align="left" valign="top">
<SELECT NAME="bug_severity" MULTIPLE SIZE="7">
<OPTION VALUE="blocker">blocker<OPTION VALUE="critical">critical<OPTION VALUE="major">major<OPTION VALUE="normal">normal<OPTION VALUE="minor">minor<OPTION VALUE="trivial">trivial<OPTION VALUE="enhancement">enhancement</SELECT>
</td>
</tr>
</table>
</td>
</tr>
</table>
</center>

<br>

<b>ơ</b>  <b>ˡ</b> ΥեɤϡХΥ饤ե
פ롣<b>ץåȥե</b>  <b>OS</b> ϡ
Х¸륷ƥ򵭽Ҥ롣<b>ͥ</b>  <b></b>
פΤΤΤ

<a name="status"></a>
<p><b>ơ</b> 

<ul>

<li><b>UNCONFIRMED</b> - ï⤳ΥХ٤ʤΤǧ
ʤ٤¤ĥ桼ΥХˤĤƳΤᡢΥơ
 NEW ѹ뤫ΤʤʤϤ<a
href="userprefs.cgi?bank=permissions">ʬθ</a> Ǹ뤳Ȥ
롣Хľܲ褵 RESOLVED ޡ⤢뤬
ƤϥХϤƤ줿ͤˤäƳΤ롣ïΥХ
ݡºݤ˵äƤ뤳ȤˤäƸڤޤǤϡ 
UNCOMFIRMED ʥХϤޤ̤ǧΤޤ޻Ĥ롣

<li><b>NEW</b> - ΥХϺǶôԤΥХꥹȤɲä줿Τǡ
Ͻɬפ롣ξ֤ΥХϵĤ ASSIGNED Ȥʤ뤫
¾οͤ˥ѥϤˤNEWΤޤޤǤ뤫褵 
RESOLVED ޡ롣

<li><b>ASSIGNED</b> - ΥХϤޤ褵ƤʤǤ
ȹͤï˳ƤƤ롣ξ֤顢Х¾οͤϤ졢
NEW ˤʤ뤳Ȥꡢ뤤ϲ褵 RESOLVED ޡ롣

<li><b>REOPENED</b> - ΥХϰٲ褵줿βϸäƤ
㤨Сܤ󤬸줿Ȥˤϡ WORKSFORME ΥХ REOPENED 
ȤʤꡢΥХϸߺƸǽäƤ롣ξ֤顢Х 
ASSIGNED  RESOLVED ξξ֤ˤʤꤦ롣

<li><b>RESOLVED</b> - 褵졢QA(ʼɾô)ˤ븡ڤԤäƤ
֤Ǥ롣ξ֤顢ХϺ٥ץ󤵤 REOPENED Ȥʤ뤫
VERIFIED ˥ޡ롣뤤ϡɤ֤Ǥ뤿˥졢
CLOSED ˥ޡ롣

<li><b>VERIFIED</b>- QA ϤΥХ򸫤ơΥХ褵졢Ŭڤʽ
֤Ԥ뤳Ȥ˻Ƥ롣

<li><b>CLOSED</b> - ΥХϡֻפȸʤˡŬڤǤꡢ
𤵤줿Х٤ơʤв٤줿֤Ǥ롣ӤȤƺƤ
Ͼ⤭뤳ȤХϤɤʤΤǡREPOENED ȤʤäƤΤ
ʾ֤ˤʤʤФʤʤޤǤξ֤Ȥ줿ȤϴǤ롣
</ul>

<a name="resolution"></a>
<p><b>ˡ</b> 

<p><b>ˡ</b> ΥեɤϡХ˲ä򼨤ΤǤ롣

<p>ޤβ(resolution)¸ߤʤ: "open" ֤ΰĤ°뤹٤ƤΥХ
(֤ resolution ȤϤʤδطʤ) ϥ֥󥯤ꤵƤ롣
٤Ƥ¾ΥХϸҤˡΤɤ줫˥ޡƤ롣

<ul>
<li><b>FIXED</b> - Хϡĥ꡼˥å󤵤뤿˥եåƤ롣
<li><b>INVALID</b> - ХǤϤʤȤ줿ꡣ
<li><b>WONTFIX</b> - ˤ錄äƽ뤳ȤϤʤȤ줿ꡣ
<li><b>LATER</b> - ʤθСǤϽ뤳ȤʤȤ줿ꡣ
<li><b>REMIND</b> - ΥСǤϽ븫ߤʤβǽޤĤäƤꡣ
<li><b>DUPLICATE</b> - ¸ߤƤХȽʣƤꡣduplicate ȥޡ뤿ˤϡʣХֹ椬ɬפǤꡢֹϥХεҤ֤롣
<li><b>WORKSFORME</b> - ٤ƤοͤΥХϺƸȹͤɤɤǤ⤳Τ褦ʤȤεΤĤʤ硣⤷äȾ󤬤ȤǸ줿顢٥ХľȤˤߤñ˥ե뤷ƤΤΤǤ롣
</ul>

<a name="platform"></a>
<p><b>ץåȥե</b>
<p><b>ץåȥե</b> եɤϡХ𤵤줿ϡɥץåȥեǤ롣ˡŪʥץåȥեबޤޤƤ뤬ΤΤ˸¤ʤ:

<ul>
<li>All (٤ƤΥץåȥեǵ; ץåȥեʥХ)<br>
<li>Macintosh
<li>PC
<li>Sun
<li>HP
</ul>
<p><b>Note:</b> "All" ץ򤹤뤳Ȥϡ٤ƤΥץåȥե˳Ƥ줿Х򤹤뤳ȤˤϤʤʤϤ٤ƤΥץåȥեǤΥХ <b></b> ȤȤ򤷤Ƥ˲᤮ʤ

<a name="opsys"></a>
<p><b>OS</b>
<p><b>OS</b>ΥեɤϡХ𤵤줿ڥ졼ƥ󥰥ƥǤ롣ˡʥڥ졼ƥ󥰥ƥޤबΤΤ˸¤ʤ:

<ul>
<li>All (٤ƤΥץåȥեǵ; ץåȥեΥХ)
<li>Windows 95
<li>Windows 2000
<li>Mac System 8.0
<li>Linux
<li>Other (OSΤɤˤ°ʤOS)<br>
</ul>

<p>ڥ졼ƥ󥰥ƥϥץåȥեŤ˼ˤǤϤʤ㤨СLinux  PC  Mac ΤۤΥץåȥեǤư롣

<a name="priority"></a>
<p><b>ͥ</b>

<p><b>ͥ</b>Ͻ礵ȥեå뤿ν֤ɽ魯Υեɤϥץޤ䥨󥸥˥ʬλŻ̤ͥĤ뤿˻ȤƤ롣ͥ٤ˤ P1 (ͥ) 顢 P5(Ǥ㤤ͥ)ޤǤ롣

<a name="severity"></a>
<p><b></b>

<p><b></b> ϡХο٤ɽ魯

<ul>
<li><b>Blocker</b> - ȯȥƥȤΰޤξ˸Ρ<br>
<li><b>Critical</b> - å塢ǡ»ʥ꡼<br>
<li><b>Major</b> - פʵǽηǡ<br>
<li><b>Normal</b> - ̤ΥХ<br>
<li><b>Minor</b> - ޥʡʵǽηǡ뤤ϸߴñؼʤ¾ꡣ<br>
<li><b>Trivial</b> - ñǤְ㤤ƥȤ֥ߥʤɤΡɽؾꡣ<br>
<li><b>Enhancement</b> - ǽĥΥꥯȡ<br>
</ul>

};












print qq{
<a name="peopleinvolved"></a>
<p><br><center><h3>ط</h3></center>
<center>


<table width="390" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td height="180" align="center">

<table>
<tr>
<td valign="middle">Email:
<input name="email1" size="25" value="">&nbsp;</td><td valign="top">matching as:<br>
<SELECT NAME="emailtype1"><OPTION VALUE="regexp">regexp
<OPTION VALUE="notregexp">not regexp
<OPTION VALUE="substring">substring
<OPTION VALUE="exact">exact
</SELECT>
</td>
</tr>
<tr>
<td colspan="2" align="center">ϼΤ줫Υեɤ˰פ:</td>
</tr>
<tr>
<td colspan=2>
<center>
<input type="checkbox" name="emailassigned_to1" value="1">Assigned To
<input type="checkbox" name="emailreporter1" value="1">Reporter

<input type="checkbox" name="emailqa_contact1" value="1">QA Contact
</center>
</td>
</tr>
<tr>
<td colspan=2 align="center">
<input type="checkbox" name="emailcc1" value="1">CC
<input type="checkbox" name="emaillongdesc1" value="1">Added comment
</td>
</tr>
</table>

</td>
</tr>
</table>
</center>
<br>

ʬϡǽϤΤˤʣˤʤꡢǰʤʬˤΤȤʤäƤ롣
ǤϡХ˴طŻҥ᡼륢ɥ쥹򸡺Ǥ롣

<p>

ҤȤĤŻҥ᡼륢ɥ쥹˴طХõˤ:

<ul>
  <li> Żҥ᡼륢ɥ쥹ΰƥȥեɤ˥פ롣
  <li> Υɥ쥹ޤޤƤȻפեɤΥåܥå򥯥å롣
</ul>

<p>

Ĥΰۤʤä᡼륢ɥ쥹õȤ롣ξǤƤΤʤ顢ξΥ᡼륢ɥ쥹˥ޥåХɽ롣㤨СRalph ˤäƺ졢Fred ˳Ƥ줿Х򸡺ȤͭѤǤ롣

<p>

ɥåץ˥塼ʬפˤޥåϤˡ<a href="http://www.mozilla.org/bugs/text-searching.html">ɽ(Regular
Expressions)</a>ˤäƤԤȤ뤷٤ꤵ줿᡼륢ɥ쥹פõȤǽǤ롣


};











print qq{
<a name="textsearch"></a>
<p><br><center><h3>ƥȸ</h3></center>
<center>



<table width="610" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="210" >

<table>
<tr>
<td align="right"><a href="queryhelp.cgi#summaries">Хγ</a>:</td>
<td><input name="short_desc" size="30" value=""></td>
<td><SELECT NAME="short_desc_type">
<OPTION VALUE="substring">case-insensitive substring
<OPTION VALUE="casesubstring">case-sensitive substring
<OPTION VALUE="allwords">all words
<OPTION VALUE="anywords">any words
<OPTION VALUE="regexp">regular expression
<OPTION VALUE="notregexp">not ( regular expression )
</SELECT></TD>
</tr>
<tr>
<td align="right"><a href="queryhelp.cgi#descriptions">ˡ</a>:</td>
<td><input name="long_desc" size="30" value=""></td>
<td><SELECT NAME="long_desc_type">
<OPTION VALUE="substring">case-insensitive substring
<OPTION VALUE="casesubstring">case-sensitive substring
<OPTION VALUE="allwords">all words
<OPTION VALUE="anywords">any words
<OPTION VALUE="regexp">regular expression
<OPTION VALUE="notregexp">not ( regular expression )
</SELECT></TD>
</tr>
<tr>
<td align="right"><a href="queryhelp.cgi#url">ϢŤ줿 URL</a>:</td>
<td><input name="bug_file_loc" size="30" value=""></td>
<td><SELECT NAME="bug_file_loc_type">
<OPTION VALUE="substring">case-insensitive substring
<OPTION VALUE="casesubstring">case-sensitive substring
<OPTION VALUE="allwords">all words
<OPTION VALUE="anywords">any words
<OPTION VALUE="regexp">regular expression
<OPTION VALUE="notregexp">not ( regular expression )
</SELECT></TD>
</tr>
<tr>
<td align="right"><a href="queryhelp.cgi#statuswhiteboard">Status whiteboard</a>:</td>
<td><input name="status_whiteboard" size="30" value=""></td>
<td><SELECT NAME="status_whiteboard_type">
<OPTION VALUE="substring">case-insensitive substring
<OPTION VALUE="casesubstring">case-sensitive substring
<OPTION VALUE="allwords">all words
<OPTION VALUE="anywords">any words
<OPTION VALUE="regexp">regular expression
<OPTION VALUE="notregexp">not ( regular expression )
</SELECT></TD>
</tr>

<TR>
<TD ALIGN="right"><A HREF="queryhelp.cgi#keywords">Keywords</A>:</TD>
<TD><INPUT NAME="keywords" SIZE="30" VALUE=""></TD>
<TD>
<SELECT NAME="keywords_type"><OPTION VALUE="anywords">Any of the listed keywords set
<OPTION VALUE="allwords">All of the listed keywords set
<OPTION VALUE="nowords">None of the listed keywords set
</SELECT></TD></TR>
</table>
</td></tr>
</table>
</center>
<br>


<p>ξϤǤϡͤϤ٤ƤΥХ椫鸡ԤȤ(¾
Υեɤ˵뤳ȤˤäơХ¤뤳Ȥ) 
<a href="http://www.mozilla.org/bugs/text-searching.html">ɽ</a> 
ƥȥˤĤΤꤿȹͤΤʤС<a
href="http://www.mozilla.org/bugs/text-searching.html">Bugzilla ƥȸ</a>
򸫤Ȥ⤷ʤΥեɤ³ܥåϰפɤΤ褦
ޤ뤫ꤹ롣<br>

<a name="summaries"></a>
<h4>Хγ</h4>
<p>ιܤǡ򸡺롣ϥХɽԤǤ롣

<a name="descriptions"></a>
<h4>ҤΥȥ꡼</h4>

<p>ιܤǡȤ򸡺뤳ȤǤ롣ȤϤɤʿͤ
ɲäǽǤꡢۤȤɤΥХǡȤϵʸǽʥꥢäƤ롣
ΰפ̤ΤǤСȤθǽȤʤ
ȤǥХϤҤɤ礭ʤǽΤǡ
ΥפΥ꡼Ԥȡʤλ֤פ롣

<a name="url"></a>
<h4>ϢŤ줿 URL</h4>
<p>ιܤǡURL Υեɤ򸡺뤳Ȥ롣ϥХˤĤƤΥ֥ڡURLޤǤ롣

<a name="statuswhiteboard"></a>
<h4>Status Whiteboard</h4>
<p>ιܤǡХ status whiteboard 򸡺뤳Ȥ롣 status whiteboard ϥ󥸥˥ɲäŪʾޤǤ
};


print qq{
<a name="keywords"></a>
<h4>Keywords</h4>
<br><br>줾ΥХΥɤĤȤ롣Ŭڤʸ¤äХΥݡ桼ϡΥɤԽ뤳Ȥ롣ΤΤϡΥСBugzillaݻƤ륭ɤΥꥹȤǤ:
};

ConnectToDatabase();

my $tableheader = qq{
<p><table border="1" cellpadding="4" cellspacing="0">
<tr bgcolor="#6666FF">
<th align="left">Name</th>
<th align="left">Description</th>
<th align="left">Bugs</th>
</tr> 
};

print $tableheader;

my $line_count = 0;
my $max_table_size = 50;

SendSQL("SELECT keyworddefs.name, keyworddefs.description, 
                COUNT(keywords.bug_id), keywords.bug_id
         FROM keyworddefs LEFT JOIN keywords ON keyworddefs.id=keywords.keywordid
         GROUP BY keyworddefs.id
         ORDER BY keyworddefs.name");

while (MoreSQLData()) {
    my ($name, $description, $bugs, $onebug) = FetchSQLData();
    if ($bugs && $onebug) {
        # This 'onebug' stuff is silly hackery for old versions of
        # MySQL that seem to return a count() of 1 even if there are
        # no matching.  So, we ask for an actual bug number.  If it
        # can't find any bugs that match the keyword, then we set the
        # count to be zero, ignoring what it had responded.
        my $q = url_quote($name);
        $bugs = qq{<A HREF="buglist.cgi?keywords=$q">$bugs</A>};
    } else {
        $bugs = "none";
    }
    if ($line_count == $max_table_size) {
        print "</table>\n$tableheader";
        $line_count = 0;
    }
    $line_count++;
    print qq{
<tr>
<th>$name</th>
<td>$description</td>
<td align="right">$bugs</td>
</tr>
};
}

print "</table><p>\n";

quietly_check_login();

if (UserInGroup("editkeywords")) {
    print qq{<p><a href="editkeywords.cgi">Edit keywords</a>\n};
}












my %default;
my %type;

print qq{
<a name="moduleoptions"></a>
<p><br><center><h3>⥸塼륪ץ</h3></center>

<br>

<p>⥸塼륪ץϡҤȯХɤΥץΡɤΥ⥸塼ΡɤΥС󤫤򤹤ΤǤ롣İʾΥץࡢС󡢥ݡͥȡ뤤ϥޥ륹ȡꤹ뤳Ȥˤʤ롣

<p><a name="product"></a>
<h4>ץ</h4> 


<p>Mozilla ץΥ֥ץȤϻ̤äΤǤ뤬ĤڤΥ줿ץȤȯƤ롣줾ΥץȤϤ켫ȤΥݡͥȤͭƤ롣

};




$line_count = 0;
$max_table_size = 50;
my @products;

$tableheader = 	qq{ <p><table border=0><tr><td>
	<table border="1" width="100%" cellpadding="4" cellspacing="0">
	<tr bgcolor="#6666FF">
	<th align="left">Product</th>
	<th align="left">Description</th></tr> };


print qq{
	$tableheader
};


SendSQL("SELECT product,description FROM products ORDER BY product");
	while (MoreSQLData()) {

	my ($product, $productdesc) = FetchSQLData();
	push (@products, $product);

	$line_count++;
	if ($line_count > $max_table_size) {
			print qq{
			</table>
			$tableheader
		};
	  	$line_count=1;
	}

	print qq{ <tr><th>$product</th><td>$productdesc</td></tr> };


}


print qq{ 	

</table></td></tr></table> };

if (UserInGroup("editcomponents")) {
    print qq{<p><a href="editproducts.cgi">Edit products</a><p>};
}

print qq{
<p><a name="version"></a>
<h4>С</h4>

<p>ιܤñ˸ХޡƤСǤ롣¿ΥХ another С˥ޡ milestones ȥ꡼(milestone ˤĤƤϡ)

};




 
$line_count = 0;
$tableheader = qq{ 
	<p>
	<table border="1" width="100%" cellpadding="4" cellspacing="0">
	<tr bgcolor="#6666FF">
	<th align="left">Component</th>
	<th align="left">Product</th>
	<th align="left">Description</th></tr>
};

print qq{ 	
<p><a name="component"></a>
<h4>ݡͥ</h4>
<p>줾ΥץȤϥݡͥȤäƤơ줾ˤĤƤΥХϿǤ褦ˤʤäƤ롣ݡͥȤϥץȤΰǤꡢ⥸塼륪ʡ˳Ƥ롣ΥꥹȤϡݡͥȤȤ˴ϢŤ줿ץȤǤ롣:
		$tableheader
};
foreach $product (@products)
{

	SendSQL("SELECT value,description FROM components WHERE program=" . SqlQuote($product) . " ORDER BY value");

	while (MoreSQLData()) {

		my ($component, $compdesc) = FetchSQLData();

		$line_count++;
		if ($line_count > $max_table_size) {
				print qq{
				</table>
				$tableheader
			};
			$line_count=0;
		}
		print qq{<tr><th>$component</th><td>$product</td><td>$compdesc</td></tr>};
	}

}

print qq{</table>};
if (UserInGroup("editcomponents")) {
    print qq{<p><a href="editcomponents.cgi">Edit components</a><p>};
}

print qq{
<p><a name="targetmilestone"></a>
<h4>ޥ륹ȡ</h4>

<p>Υ򤹤뤳Ȥˤꡢåȥޥ륹ȡ˲餫ͤꤵ줿Х򥿡åȤ˸Ԥ롣ޥ륹ȡϥСΰǤ롣ХȯĴ뤿ΤҤȤޤΤ롢ΰŪդǤꡢŪꤷ꡼߽Ф롣㤨СMozilla.prg  "M10"  "M18" ȤΥޥ륹ȡäƤߤ "Mozilla0.9" ȤˤʤäƤ롣Bigzilla ޥ륹ȡ "Bugzilla 2.12","Bugzilla 2.14", ʤɤηǤ롣


};














print qq{
<a name="incexcoptions"></a>
<p><br><center><h3>/(Inclusion/Exclusion) ץ</h3></center>

<center>


<table width="480" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center"  height="260" >
<table>

<tr>
<td>
<SELECT NAME="bugidtype">
<OPTION VALUE="include">Only
<OPTION VALUE="exclude" >Exclude
</SELECT>
bugs numbered: 
<INPUT TYPE="text" NAME="bug_id" VALUE="" SIZE=15>
</td>
</tr>
<tr>
<td>
Changed in the last <INPUT NAME=changedin SIZE=3 VALUE=""> days
</td>
</tr>
<tr>
<td>
Containing at least <INPUT NAME=votes SIZE=3 VALUE=""> votes
</td>
</tr>
<tr>
<td>
Where the field(s)
<SELECT NAME="chfield" MULTIPLE SIZE=4>
<OPTION VALUE="[Bug creation]">[Bug creation]<OPTION VALUE="assigned_to">assigned_to<OPTION VALUE="bug_file_loc">bug_file_loc<OPTION VALUE="bug_severity">bug_severity<OPTION VALUE="bug_status">bug_status<OPTION VALUE="component">component<OPTION VALUE="everconfirmed">everconfirmed<OPTION VALUE="groupset">groupset<OPTION VALUE="keywords">keywords<OPTION VALUE="op_sys">op_sys<OPTION VALUE="priority">priority<OPTION VALUE="product">product<OPTION VALUE="qa_contact">qa_contact<OPTION VALUE="rep_platform">rep_platform<OPTION VALUE="reporter">reporter<OPTION VALUE="resolution">resolution<OPTION VALUE="short_desc">short_desc<OPTION VALUE="status_whiteboard">status_whiteboard<OPTION VALUE="target_milestone">target_milestone<OPTION VALUE="version">version<OPTION VALUE="votes">votes
</SELECT> changed to <INPUT NAME="chfieldvalue" SIZE="10">
</td>
</tr>
<tr>
<td colspan=2>
During dates <INPUT NAME="chfieldfrom" SIZE="10" VALUE="">
to <INPUT NAME="chfieldto" SIZE="10" VALUE="Now">
</td>
</tr>
<tr>
<td>

</td>
</tr>
</table>

</td>
</tr>
</table>

</center>
<br>

<p>/(Inclusion/Exclusion) ץϡ
Ϥͤ˴ŤޤͤǤ붯ϤʥǤ롣

<P><b>[Only, Exclude] bugs numbered [text] </b>

<p>ν񼰤ϡʤ̤˵륫޶ڤΥХΥꥹȤΤߤ
̤椫֤Ȥ뤷뤳Ȥ롣Ūˤϡ
ϰϻ뤳Ȥ˾ޤ㤨 [1-1000] Ȥ뤳Ȥǡ 
11000Ȥ褦ˡˤǰʤ鸽ߤϽʤ

<p><b>Changed in the last [text] days</b>

<p>ꤷ˾֤ѲХ

<p><b>At least [text] votes</b>

<p>ꤷʾɼХ

<p><b>Where the field(s) [fields] changed to [text]</b>

<p>ˤꡢ
Х¸ߤƤ¸ߤ椫鸡ͤꤹ뤳Ȥ롣
⤷İʾΥեɤȤ顢
˰֤եɤΤҤȤĤ˽񤭹ޤʤФʤʤ
Υեɤ̣뤳Ȥ򤹤Τ񤷤Τʤ
⤷ʤ꡼ν鿴ԤȤ顣
ϥХ͡ʥեɤ˥ޥå롣
ޤĤΥեɤϤǤʤС
եɤѹ줿ͤɤǤ뤫ȤȤϤ뤳Ȥ롣
㤨СХγƤ jon\@netscape.com  brian\@netscape.com
ѹˤʤä硢assigned_to changed to brian\@netscape.com
Ϥ뤳Ȥ롣

<p><b>During dates [text] to [text] </b>

<p>ǡեɤѹ줿ͤѹ뤳Ȥ롣"Now" ϥ
ȥ꡼ȤƻѲǽǤ롣¾Υȥ꡼mm/dd/yyyy 뤤 
yyyy-mm-dd Ȥ񼰤ǻ롣


};












print qq{
<a name="advancedquerying"></a>
<p><br><center><h3>"Boolean Charts" Ѥ٤ʸ</h3></center>

<p>Bugzilla θڡϡʤĤ䤹褦߷פƤ롣
Τ褦ʻȤ䤹ϡˤ­⤿ι٤
ΥϡȤƤ⶯ϤʸǤ褦߷פƤ롣
ϳؤ֤ΤΤñʤȤǤϤʤ<br> <p> <center>

<table width="780" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center"  height="140" >
<table>
<tr><td>
<table><tr><td>&nbsp;</td><td><SELECT NAME="field0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-0-0" VALUE=""><INPUT TYPE="button" VALUE="Or" ><INPUT TYPE="button" VALUE="And" 
	NAME="cmd-add0-1-0"></td></tr>
    
		<tr><td>&nbsp;</td><td align="center">
         &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <INPUT TYPE="button" VALUE="Add another boolean chart" NAME="cmd-add1-0-0">
       
        
</td></tr>
</table>
</td></tr>
</table>
</td>
</tr>
</table>

</center> <br> <p>٤ʸ (or Boolean Chart) ϰĤ "term()" 
Ϥޤ롣ҤȤĤ term ĤΥץ˥塼ȥƥȥեɤȤ߹碌Ǥ롣
˥塼֤ȤˤꡢΤȤꤹ:
<p>ե 1: Ѹõ<br> ե 
2: ޥåΤꤹ<br>
ե 3: ʤˤΤθʤΤ<br> <br> <center>

<table width="790" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="160" >
<table>
<tr><td>
<table><tr><td>&nbsp;</td><td><SELECT NAME="field0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-0-0" VALUE=""></td></tr><tr><td><b>OR</b></td><td><SELECT NAME="field0-0-1"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-0-1"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-0-1" VALUE=""><INPUT TYPE="button" VALUE="Or" NAME="cmd-add0-0-2" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"><INPUT TYPE="button" VALUE="And" 
	NAME="cmd-add0-1-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"></td></tr>
    
		<tr><td>&nbsp;</td><td align="center">
         &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <INPUT TYPE="button" VALUE="Add another boolean chart" NAME="cmd-add1-0-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;">
       
        
</td></tr>
</table>
</td></tr>
</table>
</td>
</tr>
</table>

</center>

<br> <p>򤤤ȤϤޤΤϡ"Or" ޤ "And" ܥ򲡤
ȤǤ롣⤷ "Or" ܥ򲡤ʤ顢ǽΤΤβˡܤ 
term 뤳Ȥˤʤ롣 term ꤹ뤳ȤǤη̤Ϥ
term ˤ match ٤ƤΤΤˤʤ롣<br> <p> <center>

<table width="790" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="180" >

<table>
<tr><td>

<table><tr><td>&nbsp;</td><td><SELECT NAME="field0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-0-0" VALUE=""><INPUT TYPE="button" VALUE="Or" NAME="cmd-add0-0-1" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"></td></tr><tr><td>&nbsp;</td><td align="center" valign="middle"><b>AND</b></td></tr><tr><td>&nbsp;</td><td><SELECT NAME="field0-1-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-1-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-1-0" VALUE=""><INPUT TYPE="button" VALUE="Or" NAME="cmd-add0-1-1" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"><INPUT TYPE="button" VALUE="And" 
	NAME="cmd-add0-2-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"></td></tr>
    
		<tr><td>&nbsp;</td><td align="center">
         &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <INPUT TYPE="button" VALUE="Add another boolean chart" NAME="cmd-add1-0-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;">
       
        
</td></tr>
</table>
</td></tr>
</table>
</td>
</tr>
</table>

</center> <br> <p>"And" ܥ򲡤Ȥˤϡꥸʥ term β˿
term 뤳Ȥ -  "AND" ȤɤǶڤƤꡢ
̤ϤξtermΥåȤ˰פΤȤʤ롣

<p>"And"  "Or" Υåݻ뤳Ȥ롣ƥڡʣ
term ĤȤˤʤ롣"Or"  "And" ⤤ͥ踢äƤ롣
"Or" Ϥμ()Ƥȹͤ뤳Ȥ롣

<br><p>
<center>

<table width="790" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="170" >

<table>
<tr><td>
<table><tr><td>&nbsp;</td><td><SELECT NAME="field0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type0-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value0-0-0" VALUE=""><INPUT TYPE="button" VALUE="Or" NAME="cmd-add0-0-1" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"><INPUT TYPE="button" VALUE="And" 
	NAME="cmd-add0-1-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"></td></tr>
    
		<tr>
		<td colspan="2"><hr></td>
		</tr><tr><td>&nbsp;</td><td>
		<SELECT NAME="field1-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="groupset">groupset
<OPTION VALUE="bug_id">Bug #
<OPTION VALUE="short_desc">Summary
<OPTION VALUE="product">Product
<OPTION VALUE="version">Version
<OPTION VALUE="rep_platform">Platform
<OPTION VALUE="bug_file_loc">URL
<OPTION VALUE="op_sys">OS/Version
<OPTION VALUE="bug_status">Status
<OPTION VALUE="status_whiteboard">Status Whiteboard
<OPTION VALUE="keywords">Keywords
<OPTION VALUE="resolution">Resolution
<OPTION VALUE="bug_severity">Severity
<OPTION VALUE="priority">Priority
<OPTION VALUE="component">Component
<OPTION VALUE="assigned_to">AssignedTo
<OPTION VALUE="reporter">ReportedBy
<OPTION VALUE="votes">Votes
<OPTION VALUE="qa_contact">QAContact
<OPTION VALUE="cc">CC
<OPTION VALUE="dependson">BugsThisDependsOn
<OPTION VALUE="blocked">OtherBugsDependingOnThis
<OPTION VALUE="attachments.description">Attachment description
<OPTION VALUE="attachments.thedata">Attachment data
<OPTION VALUE="attachments.mimetype">Attachment mime type
<OPTION VALUE="attachments.ispatch">Attachment is patch
<OPTION VALUE="target_milestone">Target Milestone
<OPTION VALUE="delta_ts">Last changed date
<OPTION VALUE="(to_days(now()) - to_days(bugs.delta_ts))">Days since bug changed
<OPTION VALUE="longdesc">Comment
</SELECT><SELECT NAME="type1-0-0"><OPTION SELECTED VALUE="noop">---
<OPTION VALUE="equals">equal to
<OPTION VALUE="notequals">not equal to
<OPTION VALUE="casesubstring">contains (case-sensitive) substring
<OPTION VALUE="substring">contains (case-insensitive) substring
<OPTION VALUE="notsubstring">does not contain (case-insensitive) substring
<OPTION VALUE="regexp">contains regexp
<OPTION VALUE="notregexp">does not contain regexp
<OPTION VALUE="lessthan">less than
<OPTION VALUE="greaterthan">greater than
<OPTION VALUE="anywords">any words
<OPTION VALUE="allwords">all words
<OPTION VALUE="nowords">none of the words
<OPTION VALUE="changedbefore">changed before
<OPTION VALUE="changedafter">changed after
<OPTION VALUE="changedto">changed to
<OPTION VALUE="changedby">changed by
</SELECT><INPUT NAME="value1-0-0" VALUE=""><INPUT TYPE="button" VALUE="Or" NAME="cmd-add1-0-1" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"><INPUT TYPE="button" VALUE="And" 
	NAME="cmd-add1-1-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;"></td></tr>
    
		<tr><td>&nbsp;</td><td align="center">
         &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <INPUT TYPE="button" VALUE="Add another boolean chart" NAME="cmd-add2-0-0" ONCLICK="document.forms[0].action='query.cgi#chart' ; document.forms[0].method='POST' ; return 1;">
       
        
</td></tr>
</table>
</td></tr>
</table>
</td>
</tr>
</table>


</center>
<br>

<p>äȤⵤŤˤ̯ʤȤϡ"Add another boolean chart" ܥǤ롣
ϤۤȤ "And" ܥƱǤ롣
ϡҤȤĤΥХʣιܤطŤƤեɤ
ĤȤȤɬפˤʤ 
- ϡΤΤޤ: "Comments", "CC", Ƥ٤Ƥ
"changed [something]" Υȥ꡼Ǥ롣⤷ʣ term ä硢
줬Υեɤΰ(ȤΤ褦)ˤĤƤ٤
Ҥ٤ƤΤǤäȤȡ
ΥեɤΰۤʤäʣΥ󥹥󥹤˽Τ
ҤȤĤΥ󥹥󥹤˽ΤϤäꤷʤǡ
ξˡͿterm ۤʤä 㡼Ȥ˸ʤ¤
Ʊ󥹥󥹤ɽ褦ˤ롣

<p>㤨: ⤷ "ͥ  P5 ѹˤʤä"  "̤ͥ 
person\@addr ˤäѹä", Ŭ ͥ  P5 ˤ
ѹͤ򸡺Ǥ롣⤷ˤȤˤοʪ
ä ޥ륹ȡѹˤʤꡢȤ milestone  priority  
P5 ˤ줫(ۤïβǽ) ˤäѹ줿Х򤹤٤Ƹ
ȤˡĤ term ۤʤä㡼Ȥ֤Ȥˤʤ
};


print qq{
<a name="therest"></a>
<center><h3>եλĤʬ</h3></center>
<center>


<table width="650" bgcolor="#00afff" border="0" cellpadding="0" cellspacing="0">
<tr>
<td align="center" height="190" >
<table cellspacing="0" cellpadding="0">
<tr>
<td align="left">
<INPUT TYPE="radio" NAME="cmdtype" VALUE="editnamed"> Load the remembered query:
<select name="namedcmd"><OPTION VALUE="Assigned to me">Assigned to me</select><br>
<INPUT TYPE="radio" NAME="cmdtype" VALUE="runnamed"> Run the remembered query:<br>
<INPUT TYPE="radio" NAME="cmdtype" VALUE="forgetnamed"> Forget the remembered query:<br>
<INPUT TYPE="radio" NAME="cmdtype" VALUE="asdefault"> Remember this as the default query<br>
<INPUT TYPE="radio" NAME="cmdtype" VALUE="asnamed"> Remember this query, and name it:
<INPUT TYPE="text" NAME="newqueryname"><br>
<B>Sort By:</B>
<SELECT NAME="order">
<OPTION VALUE="Reuse same sort as last time">Reuse same sort as last time<OPTION VALUE="Bug Number">Bug Number<OPTION VALUE="'Importance'">'Importance'<OPTION VALUE="Assignee">Assignee</SELECT>
</td>
</tr>
</table>
<table>
<tr>
<td>
<INPUT TYPE="button" VALUE="Reset back to the default query">
</td>
<td>
<INPUT TYPE="button" VALUE="Submit query">
</td>
</tr>
</table>
</td>
</tr>
</table>



</center>
<br>
<p>٤Ƥ򸫽Ȥˡ"Υեβˤ֥ߤΤ褦ʤΤϲ"ȻפΤʤϤʤ󤷤Ȥ˰Ф줿ǥեȤθڡǤȤȤפФȤ롣ɤΤ褦˷̤¤٤뤫ȸȤ򤹤롣줬ä "Submit" 򥯥å褦
};




print qq{

<a name="info"></a>

<br><center><h3>ΥɥȤˤĤ</h3></center>

<p>ĤθŤС Bugzilla Υɥ (Terry Weissman, Tara Hernandez ۤο͡ˤ) Ѥ <a href="mailto:netdemonz\@yahoo.com">Brian Bober</a> 񤤤
irc.mozilla.org - #mozilla, #mozwebtools, #mozillazine ʤɤǡä뤳Ȥ롣 netdemon Ȥ̤̾äƤ롣

<P>Bugzilla λˡˤĤƤΥɥȤϡMozilla.org ¾ΥȤѲǽǤ:
<br><a href="http://www.mozilla.org/quality/help/beginning-duplicate-finding.html\"> 
ޤǤ˸줿ХɤΤ褦˸뤫</a><br>
<a href="http://www.mozilla.org/bugs/">Bugzilla ΰŪʾ</a><br>
<a href="http://www.mozilla.org/quality/help/bugzilla-helper.html">Mozilla Хݡȥե</a><br>
<a href="http://www.mozilla.org/bugs/text-searching.html">Bugzilla Υƥȸ</a><br>
<a href="http://www.mozilla.org/quality/bug-writing-guidelineaas.html">ХݡȤΥɥ饤</a><br>

<p>μɮƱϤ餷 Bugzilla Υ桼ɤΤ褦 Bugzilla 
θեѤ뤫ȸȤؤˡͿ뤳Ȥˤäƥ󥸥˥뤳ȤǤ롣
 query.cgi 񤭽ơΤ褦˸"What the heck, I'll write this too".

<p><br><center><h3>ʤȤ?</h3></center>

<p>ڡ򸫤ơȤ"ΥڡϤä񤷤褦
䤬פˡ˸¹ԤɬפϤʤ"Ƥ˽ʣΤ
Ĥ뤳Ȥ˽פǤ롣
<a href="http://www.mozilla.org/quality/bug-writing-guidelines.html">ХݡȤΥɥ饤</a>
Ƥ롣Хɲ򤹤͡˻˥Х˰ݤƤ롣
顢ʤϽʣõͤ٤ƤˤȤäƤȤƤڤʤȤ򤷤ƤΤ

};








print qq{
<a name="samplequery"></a>
<p><br><center><h3>Sample Query</h3></center>

<p>Ǥϼºݤ<b>Х򸡺褦!</b> ˻Ȥ֤⤸ȡפΥǡ١Ҽڤ뤳Ȥˤ롣
<BR>ޤڡ<a target="_blank" href="http://bugzilla.mozilla.gr.jp/query.cgi">
ɥ</a>ǳƤΥɥȤ򸡺ڡξ䤹褦ˤ褦
<p>ƼΤ褦ˤ:
<ul>
<li>"ơ"եɤΤ٤ƤΥեɤʤޤˤ
<li>ƥȸǡˡֲԡסʸˡ֥᡼פϤ
ʡʸˡ֥᡼פꡢġˡֲԡפޤޤפȤ̣
</ul>

<p>̤ΤҤȤĤȤƼΤ褦ʥХɽϤ:
<a href="http://bugzilla.mozilla.gr.jp/show_bug.cgi?id=551">bug 551- ᡼ɽɥǲԤ֤</a>
};

print qq{
<hr>

<a name="bottom"></a>

</form>

};



PutFooter();
