#!/bin/sh
# Boot up Python from Bourne shell. (release type)
"exec" "python" "-O" "$0" "$@"

import os, sys, getopt, string, re, popen2

PROGNAME = 'roap'

# Import roap modules.
from roaplib import roapxml, matchobject, datasource

PARAM = 0
MSTRLIST = 1

class RoapGen:
    "roap-gen class."

    def __init__ (self, text_st, script_st):

        # Set file stream.
        self.text_st = text_st

        #
        # Reform data objects for data processing.
        #

        # Create objects.
        matchobj = matchobject.MatchObject ()
        roap_parser = roapxml.ROAPParser (script_st)

        # Parse ROAP file.
        roap = roap_parser.parse ()
        script_st.close ()

        # Rebuilding match groups.
        self.matchstr_list = []
        for region in roap.getregions ():
            param = region.get_param ()
            matchlist = region.get_matchlist ()
            mstr = matchobj.build_matchobj (matchlist)        
            self.matchstr_list.append ((param, mstr))

    def process (self):
        
        contents = []

        # Create object.
        reader = datasource.SourceReader (self.text_st)

        # Set line of delimiter.
        reader.set_delimiter ("^\s*$")
        
        # Fetch data from objectdata.
        for region in reader.get_regions ():
            
            # Exam matching objectdata.
            # `MSTRLIST' is magic number of match string.
            # `PARAM' is magic number of attribute paramater.
            for pattern in self.matchstr_list:
                match = pattern[MSTRLIST].match (region)
            
                if match and match.group () == region:
                    source = match.groups ()
                    source = string.join (source)

                    # Appear attribute of `processor',
                    # then make instance and call it.
                    if pattern[PARAM].has_key ('processor'):
                        proc = pattern[PARAM]['processor']
                        pipe_r, pipe_w = popen2.popen2 (proc)
                        pipe_w.write (source)
                        pipe_w.close ()                    
                        content = pipe_r.read ()
                        pipe_r.close ()
                        contents.append (content)                        
                    else:
                        pass
                    break
        # return converted text.
        return string.join (contents, '')
