#!/usr/bin/env python
"The list of Plain Text is changed into the list form of HTML."

import sys, re, string, cgi
from a2h import AsciiListStream, HTMLMaker

BULLET = 1
SEQUENCE = 2

class HTMLListMaker (HTMLMaker):
    def __init__ (self, astream):
        self.als = astream

        self.listtype = BULLET

        self.start_ultag = "<ul>"
        self.end_ultag = "</ul>"
        self.start_litag = "<li>"
        self.end_litag = "</li>"        

    def gethtml (self):
        print self.start_ultag
        for cell in self.als.getlist ():
            cell = cgi.escape (cell)
            print "<li>%s</li>" % cell
        return self.end_ultag

if __name__ == '__main__':
    if len (sys.argv) == 2: 
        try:
            istream = open (sys.argv[1])
        except Exception, e:
            print e
            sys.exit (1)
    elif len (sys.argv) == 1: 
        istream = sys.stdin
    else:
        print """\
Usage: %s input-text-file

Report bugs to urago@users.sourceforge.net (enable Japanese)""" % (sys.argv[0])
        sys.exit (1)

    als = AsciiListStream (istream)
    htl = HTMLListMaker (als)
    print htl.gethtml ()
