# roap CDATA node module.
"""
CDATA module.
It has process for object data.
"""
import string, re, sys, os, traceback
import roapxml

class SourceReader:
    def __init__ (self, file = sys.stdin):
        self.delimiter = re.compile ("^\s*$")
        self.file = file

    def get_delimiter (self):
        return (self.delimiter)

    def set_delimiter (self, delimiter):
        self.delimiter = re.compile (delimiter)

    def get_region (self):
        region = ""
        line = None

        while 1:
            line = self.file.readline ()
            if line == "":
                if region != "":
                    return region
                else:
                    return (None)

            line = re.sub ("\n", "", line)

            if self.delimiter.match (line) != None:
                return (region)
            else:
                region = region + line + "\n"

    def get_regions (self):
        regions = []

        while 1:
            region = self.get_region ()
            if region == None:
                break
            else:
                regions.append (region)

        return (regions)

    def len (self):
        "Examine file length."

        offset = self.file.tell ()
        len = 1

        self.file.seek (0)

        while 1:
            line = self.file.readline ()
            if line == "":
                self.file.seek (offset)
                return (len)

            line = re.sub ("\n", "", line)
            if self.delimiter.match (line) != None:
                len = len + 1

        return len
