/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robbie.dao.DaoSysException;
import robbie.dao.DaoUtil;
import robbie.dao.Query;

public class BaseDao
implements Serializable {
    private static final long serialVersionUID = -3734013538684469448L;
    private transient Connection conn = null;

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(Connection conn) throws SQLException {
        this.closeConnection();
        this.conn = conn;
    }

    protected void closeConnection() throws SQLException {
        if (this.getConnection() != null) {
            this.getConnection().close();
            this.conn = null;
        }
    }

    protected boolean isClosed() throws SQLException {
        if (this.getConnection() != null) {
            return this.getConnection().isClosed();
        }
        return false;
    }

    protected void setAutoCommit(boolean isAutoCommit) throws SQLException {
        if (!this.isClosed()) {
            this.getConnection().setAutoCommit(isAutoCommit);
        }
    }

    protected void commit() throws SQLException {
        if (!this.isClosed()) {
            this.getConnection().commit();
        }
    }

    protected void rollback() throws SQLException {
        if (!this.isClosed()) {
            this.getConnection().rollback();
        }
    }

    protected List executeQuery(Query query) throws SQLException {
        List list;
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToMapList(rs);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeQuery(sts, rs);
            throw throwable;
        }
        this.closeQuery(sts, rs);
        return list;
    }

    protected Object[][] executeQueryForArray(Query query) throws SQLException {
        Object[][] objectArray;
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            objectArray = DaoUtil.resultSetToArray(rs);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeQuery(sts, rs);
            throw throwable;
        }
        this.closeQuery(sts, rs);
        return objectArray;
    }

    protected List executeQueryForBeans(Query query, Class beanClass) throws SQLException {
        List list;
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToBeansList(beanClass, rs);
            Object var6_6 = null;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new DaoSysException(ex);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeQuery(sts, rs);
                throw throwable;
            }
        }
        this.closeQuery(sts, rs);
        return list;
    }

    protected List executeQueryForBeans(Query query) throws SQLException {
        List list;
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        if (query.getReslutClass() == null) {
            throw new IllegalArgumentException("JavaBeans\u5909\u63db\u5148\u306e\u30af\u30e9\u30b9\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToBeansList(query.getReslutClass(), rs);
            Object var5_5 = null;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new DaoSysException(ex);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.closeQuery(sts, rs);
                throw throwable;
            }
        }
        this.closeQuery(sts, rs);
        return list;
    }

    protected List executeQueryForDynaBean(Query query) throws SQLException {
        List list;
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        PreparedStatement sts = null;
        ResultSet rs = null;
        try {
            sts = this.openStatement(query.getSQLString());
            rs = this.openQuery(sts, query.getBindParametersMapList());
            list = DaoUtil.resultSetToDynaBeanList(rs);
            Object var5_5 = null;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new DaoSysException(ex);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.closeQuery(sts, rs);
                throw throwable;
            }
        }
        this.closeQuery(sts, rs);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeUpdate(Query query) throws SQLException {
        if (query == null) {
            throw new IllegalArgumentException("Query\u30d1\u30e9\u30e1\u30fc\u30bf\u304cNULL\u3067\u3059.");
        }
        int count = 0;
        PreparedStatement sts = null;
        try {
            String sqlStr = query.getSQLString();
            List params = query.getBindParametersMapList();
            sts = this.openStatement(sqlStr);
            this.bindParameters(sts, params);
            count = sts.executeUpdate();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeStatement(sts);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.closeStatement(sts);
        return count;
    }

    protected PreparedStatement openStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    protected ResultSet openQuery(PreparedStatement sts, List params) throws SQLException {
        this.bindParameters(sts, params);
        return sts.executeQuery();
    }

    protected void bindParameters(PreparedStatement sts, List params) throws SQLException {
        if (params != null) {
            int i = 1;
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                Object obj = map.get("value");
                Integer type = (Integer)map.get("type");
                if (obj != null) {
                    sts.setObject(i, obj);
                } else if (type == null) {
                    sts.setNull(i, 12);
                } else {
                    sts.setNull(i, type);
                }
                ++i;
            }
        }
    }

    protected void closeQuery(PreparedStatement sts, ResultSet rs) throws SQLException {
        this.closeResultSet(rs);
        this.closeStatement(sts);
    }

    protected void closeStatement(PreparedStatement sts) throws SQLException {
        if (sts != null) {
            sts.close();
        }
    }

    protected void closeResultSet(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }
}

