/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import robbie.dao.DaoSysException;
import robbie.util.CollectionsUtil;
import robbie.util.InstanceFactory;

public class DaoUtil {
    private static final Log LOG = LogFactory.getLog((Class)(class$robbie$dao$DaoUtil == null ? (class$robbie$dao$DaoUtil = DaoUtil.class$("robbie.dao.DaoUtil")) : class$robbie$dao$DaoUtil));
    static /* synthetic */ Class class$robbie$dao$DaoUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Integer;

    private DaoUtil() {
    }

    public static List resultSetToMapList(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            while (rs.next()) {
                Map columnMap = CollectionsUtil.createMap();
                for (int i = 0; i < columnNames.length; ++i) {
                    int object_i = i + 1;
                    columnMap.put(columnNames[i], rs.getObject(object_i));
                }
                list.add(columnMap);
            }
        }
        return list;
    }

    public static Object[][] resultSetToArray(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            Object[] columnNames = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            list.add(columnNames);
            while (rs.next()) {
                Object[] columnValue = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    int object_i = i + 1;
                    columnValue[i] = rs.getObject(object_i);
                }
                list.add(columnValue);
            }
        }
        Object[] before = list.toArray();
        Object[][] after = new Object[before.length][];
        for (int i = 0; i < before.length; ++i) {
            after[i] = (Object[])before[i];
        }
        return after;
    }

    public static final List resultSetToBeansList(Class beanClass, ResultSet rs) throws Exception {
        List beanList = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = rsMetaData.getColumnName(i + 1);
            }
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors == null) {
                return beanList;
            }
            Map descriptorMap = CollectionsUtil.createMap();
            for (int i = 0; i < descriptors.length; ++i) {
                descriptorMap.put(descriptors[i].getName().toLowerCase(), descriptors[i]);
            }
            while (rs.next()) {
                Object bean = InstanceFactory.createInstance(beanClass);
                for (int i = 0; i < columnNames.length; ++i) {
                    String columnName = DaoUtil.columnNameToPropertyName(columnNames[i]).toLowerCase();
                    if (!descriptorMap.containsKey(columnName)) continue;
                    PropertyDescriptor descriptor = (PropertyDescriptor)descriptorMap.get(columnName);
                    Object arg = DaoUtil.getObjectFromResultSet(descriptor.getPropertyType(), rs, i + 1);
                    Object[] args = new Object[]{arg};
                    descriptor.getWriteMethod().invoke(bean, args);
                }
                beanList.add(bean);
            }
        }
        return beanList;
    }

    public static final List resultSetToDynaBeanList(ResultSet rs) throws Exception {
        List list = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int name_i = i + 1;
                columnNames[i] = rsMetaData.getColumnName(name_i);
            }
            while (rs.next()) {
                LazyDynaBean bean = new LazyDynaBean();
                MutableDynaClass beanClass = (MutableDynaClass)bean.getDynaClass();
                for (int i = 0; i < columnNames.length; ++i) {
                    int object_i = i + 1;
                    String propertyName = DaoUtil.columnNameToPropertyName(columnNames[i]);
                    Object value = rs.getObject(object_i);
                    beanClass.add(propertyName, value.getClass());
                    bean.set(propertyName, value);
                }
                list.add(bean);
            }
        }
        return list;
    }

    public static final Map beansToMap(Object beans) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (beans instanceof Map) {
            Map map = CollectionsUtil.createMap();
            map.putAll((Map)beans);
            return map;
        }
        if (beans instanceof DynaBean) {
            return DaoUtil.dynaBeanToMap((DynaBean)beans);
        }
        return DaoUtil.javaBeansToMap(beans);
    }

    protected static final Map dynaBeanToMap(DynaBean bean) {
        Map map = CollectionsUtil.createMap();
        if (bean == null) {
            return map;
        }
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty prop = props[i];
            String propertyName = prop.getName();
            map.put(propertyName, bean.get(propertyName));
        }
        return map;
    }

    protected static final Map javaBeansToMap(Object beans) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Map map = CollectionsUtil.createMap();
        if (beans == null) {
            return map;
        }
        Class<?> beansClass = beans.getClass();
        BeanInfo info = Introspector.getBeanInfo(beansClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        if (descriptors == null) {
            return null;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            Object[] args = new Object[]{};
            map.put(descriptors[i].getName(), descriptor.getReadMethod().invoke(beans, args));
        }
        return map;
    }

    protected static String columnNameToPropertyName(String columnName) {
        return columnName.replaceAll("[_]", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object getObjectFromResultSet(Class type, ResultSet rs, int i) throws SQLException, IOException {
        if ((class$java$lang$String == null ? (class$java$lang$String = DaoUtil.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
            return rs.getString(i);
        }
        if (Integer.TYPE.equals(type)) {
            return new Integer(rs.getInt(i));
        }
        if (Long.TYPE.equals(type)) {
            return new Long(rs.getLong(i));
        }
        if (Short.TYPE.equals(type)) {
            return new Short(rs.getShort(i));
        }
        if (Float.TYPE.equals(type)) {
            return new Float(rs.getFloat(i));
        }
        if (Double.TYPE.equals(type)) {
            return new Double(rs.getDouble(i));
        }
        if (Boolean.TYPE.equals(type)) {
            return new Boolean(rs.getBoolean(i));
        }
        if (Byte.TYPE.equals(type)) {
            return new Byte(rs.getByte(i));
        }
        if (Character.TYPE.equals(type)) {
            Reader reader = null;
            try {
                reader = rs.getCharacterStream(i);
                int ch = reader.read();
                Character c = new Character((char)ch);
                return c;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        if ((class$java$sql$Array == null ? (class$java$sql$Array = DaoUtil.class$("java.sql.Array")) : class$java$sql$Array).equals(type)) {
            return rs.getArray(i);
        }
        if ((class$java$sql$Blob == null ? (class$java$sql$Blob = DaoUtil.class$("java.sql.Blob")) : class$java$sql$Blob).equals(type)) {
            return rs.getBlob(i);
        }
        if ((class$java$sql$Clob == null ? (class$java$sql$Clob = DaoUtil.class$("java.sql.Clob")) : class$java$sql$Clob).equals(type)) {
            return rs.getClob(i);
        }
        if ((class$java$sql$Date == null ? (class$java$sql$Date = DaoUtil.class$("java.sql.Date")) : class$java$sql$Date).equals(type)) {
            return rs.getDate(i);
        }
        if ((class$java$sql$Ref == null ? (class$java$sql$Ref = DaoUtil.class$("java.sql.Ref")) : class$java$sql$Ref).equals(type)) {
            return rs.getRef(i);
        }
        if ((class$java$sql$Time == null ? (class$java$sql$Time = DaoUtil.class$("java.sql.Time")) : class$java$sql$Time).equals(type)) {
            return rs.getTime(i);
        }
        if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DaoUtil.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).equals(type)) {
            return rs.getTimestamp(i);
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DaoUtil.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(type)) {
            return rs.getBigDecimal(i);
        }
        if ((class$java$net$URL == null ? (class$java$net$URL = DaoUtil.class$("java.net.URL")) : class$java$net$URL).equals(type)) {
            return rs.getURL(i);
        }
        return rs.getObject(i);
    }

    protected static final Object convertObjectIfNeeded(Class objClass, String propName, String columnName, Object obj) {
        if (LOG.isDebugEnabled()) {
            String className = null;
            className = obj != null ? obj.getClass().getName() : "null";
            LOG.debug((Object)("\u578b\u5909\u63db\u60c5\u5831 \u30ab\u30e9\u30e0:" + columnName + "(\u578b=" + className + ":\u5024=" + obj + ") => " + "\u30d7\u30ed\u30d1\u30c6\u30a3:" + propName + "(\u578b=" + objClass.getName() + ")"));
        }
        if (DaoUtil.isPrimitiveType(objClass)) {
            if (Integer.TYPE.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Integer(((Number)obj).intValue());
                }
                if (obj == null) {
                    return new Integer(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cInteger\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Long(((Number)obj).longValue());
                }
                if (obj == null) {
                    return new Long(0L);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cLong\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Short(((Number)obj).shortValue());
                }
                if (obj == null) {
                    return new Short(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cShort\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                }
                if (obj == null) {
                    return new Float(0.0f);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cFloat\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                }
                if (obj == null) {
                    return new Double(0.0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cDouble\u307e\u305f\u306fNumber\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Boolean.TYPE.equals(objClass)) {
                if (obj instanceof Boolean) {
                    return obj;
                }
                if (obj == null) {
                    return new Boolean(false);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cBoolean\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Byte.TYPE.equals(objClass)) {
                if (obj instanceof Byte) {
                    return obj;
                }
                if (obj == null) {
                    return new Byte(0);
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cByte\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
            if (Character.TYPE.equals(objClass)) {
                if (obj instanceof Character) {
                    return obj;
                }
                if (obj == null) {
                    return new Character('\u0000');
                }
                throw new DaoSysException("\u5909\u63db\u524d\u306e\u578b\u304cCharacter\u3067\u306f\u3042\u308a\u307e\u305b\u3093. obj=" + obj);
            }
        } else if (obj instanceof Number) {
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = DaoUtil.class$("java.lang.Integer")) : class$java$lang$Integer).equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return new Integer(((Number)obj).intValue());
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                return new Long(((Number)obj).longValue());
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                return new Short(((Number)obj).shortValue());
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                return new Float(((Number)obj).floatValue());
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                return new Double(((Number)obj).doubleValue());
            }
        }
        return obj;
    }

    private static boolean isPrimitiveType(Class objClass) {
        return Integer.TYPE.equals(objClass) || Long.TYPE.equals(objClass) || Float.TYPE.equals(objClass) || Double.TYPE.equals(objClass) || Boolean.TYPE.equals(objClass) || Short.TYPE.equals(objClass) || Byte.TYPE.equals(objClass) || Character.TYPE.equals(objClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

