/*
 * Decompiled with CFR 0.152.
 */
package robbie.util;

import java.lang.reflect.Constructor;
import robbie.util.ClassFactory;
import robbie.util.InstanceCreateFailureException;

public class InstanceFactory {
    public static Object createInstance(String className) {
        try {
            return ClassFactory.getClass(className).newInstance();
        }
        catch (Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, ClassLoader loader) {
        try {
            if (loader == null) {
                return InstanceFactory.createInstance(className);
            }
            return ClassFactory.getClass(className, loader).newInstance();
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, Object[] args) {
        try {
            return InstanceFactory.createInstance(ClassFactory.getClass(className), args);
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(String className, Object[] args, ClassLoader loader) {
        try {
            if (loader == null) {
                return InstanceFactory.createInstance(className, args);
            }
            Class<?> objClass = Class.forName(className, true, loader);
            return InstanceFactory.createInstance(objClass, args);
        }
        catch (Exception ex) {
            if (ex instanceof InstanceCreateFailureException) {
                throw (InstanceCreateFailureException)ex;
            }
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(Class classObj) {
        try {
            return classObj.newInstance();
        }
        catch (Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }

    public static Object createInstance(Class objClass, Object[] args) {
        try {
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            Constructor con = objClass.getConstructor(argClasses);
            return con.newInstance(args);
        }
        catch (Exception ex) {
            throw new InstanceCreateFailureException("InstanceFactory::createInstance() failed", ex);
        }
    }
}

