/*
 * Copyright 2006 Robbie.JP
 */
package robbie.dao.resource;

import java.sql.Connection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JdbcConnectionProxyNXB<p>
 * @since 1.1.0
 */
public class JdbcConnectionProxy extends ThreadLocal {
    
    private static final Log LOG = LogFactory.getLog(JdbcConnectionProxy.class);
    
    /**
     * Xbh[Jϐ̃RlNVԂ
     * @return ConnectionIuWFNg
     */
    public Connection getConnection() {
        
        Object obj = get();
        if (obj != null && !(obj instanceof Connection)) {
            obj = null;
            set(obj);
        }
        
        if (LOG.isDebugEnabled()) {
            LOG.debug(
                "Xbh[JϐRlNV擾܂. " + 
                "Thread=" + Thread.currentThread() + 
                ", Connection=" + obj + 
                ", Proxy=" + this);
        }
        
        return (Connection)obj;
    }
    
    /**
     * RlNVXbh[JϐƂăZbg܂B
     * @param conn ConnectionCX^X
     */
    public void setConnection(Connection conn) {
        
        if (conn == null) {
            throw new IllegalArgumentException("Connection is NULL");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(
                "Xbh[JϐɃRlNVۑ܂. " + 
                "Thread=" + Thread.currentThread() + 
                ", Connection=" + conn + 
                ", Proxy=" + this);
        }
        set(conn);
    }
}
