/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.s;

import java.util.List;

import java.sql.SQLException;

import robbie.dao.BaseDao;
import robbie.dao.DaoSysException;
import robbie.dao.Query;

import robbie.dao.resource.DbResource;


/**
 * BaseDAOpăf[^x[XɊȈՓIɐڑDAONXB<p>
 */
public class SDao extends BaseDao {

    private static final long serialVersionUID = -1223162757287442412L;
    
    private DbResource resource = null;
    
    /**
     * f[^x[XڑvpeBZbgB<p>
     * @param resource f[^x[Xڑ\[X 
     * @since 1.2.0
     */
    public void setDbResource(DbResource resource) {
        this.resource = resource;
    }
    
    /**
     * f[^x[XāǍʂMapLisť`ŕԂB<p>
     * @param sql
     * @return 1R[h1MapƂčXVʂԂB
     * @throws SQLException
     */
    public List query(Query sql) throws SQLException {
        
        try{
            super.setConnection(resource.getConnection());
            return super.executeQuery(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XāǍʂ2ž`ŕԂB<p>
     * @param sql SQLCX^X
     * @return ʂłObject2z
     * @throws SQLException
     */
    public Object[][] queryForArray(Query sql) throws SQLException {
        
        try{
            super.setConnection(resource.getConnection());
            return super.executeQueryForArray(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XāǍʂJavaBeansListŕԂB<p>
     * @since 1.2.0
     * @param sql SQLCX^X
     * @return ʂłJavaBeansList
     * @throws SQLException
     */
    public List queryForBeans(Query sql) throws SQLException {
        
        try{
            super.setConnection(resource.getConnection());
            return super.executeQueryForBeans(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XāǍʂDynaBeanListŕԂB<p>
     * @since 1.3.0
     * @param sql SQLCX^X
     * @return ʂłDynaBeansList
     * @throws SQLException
     */
    public List queryForDynaBeans(Query sql) throws SQLException {
        
        try{
            super.setConnection(resource.getConnection());
            return super.executeQueryForDynaBean(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
    
    /**
     * f[^x[XXVA̍XVԂB<p>
     * @param sql
     * @return XV
     * @throws SQLException XVɎsꍇthrow܂B
     */
    public int update(Query sql) throws SQLException {
        
        try {
            super.setConnection(resource.getConnection());
            return super.executeUpdate(sql);
        } catch(Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new DaoSysException(ex);
        } finally {
            super.closeConnection();
        }
    }
}
