/*
 * Copyright 2006 Robbie.JP
 */
package robbie.dao.x;

import java.sql.SQLException;

import java.util.List;

/**
 * GeneralizedXDaoNXB<p>
 * <pre>
 * XDao͈ÖٓIȃgUNVŁÃ\bh1gUNVƂ
 * sĂ܂܂B(ACMTɂEJBł͕Kł͂܂)
 * ̌ʁAIɃgUNV邽߂ɂ́AXDaopgDao
 * 쐬Kv܂B
 * 
 * AGeneralizedXDao͊gsȂĂAIȃgUNVsł悤
 * BaseDaöꕔAPIpublicɂ̂ɂȂ܂B
 * 
 * ɂāAOJTAȂǂgpĖIȃgUNVADao
 * gUNV̓Ƃ邱Ƃ\łB
 * 
 * ȉAR[fBOɂȂ܂B
 * 
 *         XDaoFactory factory = new XDaoFactory("etc/test-config.xml");
 *         GeneralizedXDao dao = (GeneralizedXDao)factory.createDaoInstance("GeneralizedXDao");
 *         
 *         try {
 *             // Connection̎擾
 *             dao.openConnection();
 *             dao.setAutoCommit(false);
 *             
 *             // p[^Map̐ݒ
 *             Map params = new HashMap();
 *             params.put("id", new Integer(4));
 *             params.put("name", "EEE");
 *             params.put("age",  new Integer(4));
 *             
 *             int count = dao.executeUpdate("test9", params);
 *             if (count != 1) {
 *                 dao.rollback();
 *             } else {
 *                 dao.commit();
 *             }
 *             
 *             System.out.println("updateCount=" + count);
 *             
 *         } catch(Exception ex) {
 *             try {
 *                 dao.rollback();
 *             } catch(Exception ex2) {
 *                 
 *             }
 *             throw ex;
 *         } finally {
 *             try {
 *                 // Connection
 *                 dao.closeConnection();
 *             } catch(Exception ex) {
 *                 // Ȃ
 *             }
 *         }
 * 
 * L̂悤GeneralizedXDaȍꍇɂ́ARlNVopen/closeAїO
 * ǗsKv܂Acommit/rollbackgp_ȏTuNX
 * 쐬ȂĂ\ɂȂ܂B
 * 
 * </pre>
 * @see robbie.dao.BaseDao
 * @see robbie.dao.x.XDao
 * @since 1.3.0
 */
public class GeneralizedXDao extends XDao {

    private static final long serialVersionUID = -3455411682967958400L;

    /**
     * VKɃf[^x[XRlNVI[v܂B<p>
     * @throws SQLException
     */
    public void openConnection() throws SQLException {
        super.setConnection(resource.getConnection());
    }
    
    // JavaDocsv
    public void closeConnection() throws SQLException {
        super.closeConnection();
    }
    
    // JavaDocsv
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }
    
    // JavaDocsv
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        super.setAutoCommit(isAutoCommit);
    }
    
    // JavaDocsv
    public void commit() throws SQLException {
        super.commit();
    }

    // JavaDocsv
    public void rollback() throws SQLException {
        super.rollback();
    }
    
    /**
     * BaseDao#executeQuery(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQuery(robbie.dao.Query)
     * @param id queryid
     * @param beans p[^ƂȂObjec(Map܂JavaBeans܂DynaBean)
     * @return MapList
     * @throws SQLException
     * @since 1.3.0
     */
    public List executeQuery(String id, Object beans) throws SQLException {
        return executeQuery(queryFactory.createQueryInstance(id, beans));
    }
    
    /**
     * BaseDao#executeQueryForArray(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForArray(robbie.dao.Query)
     * @param id queryid
     * @param beans p[^ƂȂObject(Map܂JavaBeans܂DynaBean)
     * @return ₢킹ʂ2z
     * @throws SQLException
     * @since 1.3.0
     */
    public Object[][] executeQueryForArray(String id, Object beans) throws SQLException {
        return executeQueryForArray(queryFactory.createQueryInstance(id, beans));
    }
    
    /**
     * BaseDao#executeQueryForBeans(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForBeans(robbie.dao.Query)
     * @param id queryid
     * @param beans p[^Object(Map܂JavaBeans܂DynaBean)
     * @return JavaBeansList
     * @throws SQLException
     * @since 1.3.0
     */
    public List executeQueryForBeans(String id, Object beans) throws SQLException {
        return executeQueryForBeans(queryFactory.createQueryInstance(id, beans));
    }
    
    /**
     * BaseDao#executeQueryForDynaBean(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeQueryForDynaBean(robbie.dao.Query)
     * @param id queryid
     * @param beans p[^Object(Map܂JavaBeans܂DynaBean)
     * @return JavaBeansList
     * @throws SQLException
     * @since 1.3.0
     */
    public List executeQueryForDynaBean(String id, Object beans) throws SQLException {
        return executeQueryForDynaBean(queryFactory.createQueryInstance(id, beans));
    }
    
    /**
     * BaseDao#executeUpdate(Query)publicɂ܂B<p>
     * @see robbie.dao.BaseDao#executeUpdate(robbie.dao.Query)
     * @param id queryid
     * @param beans p[^ƂȂObject(Map܂JavaBeans܂DynaBean)
     * @return XV
     * @throws SQLException
     */
    public int executeUpdate(String id, Object beans) throws SQLException {
        return executeUpdate(queryFactory.createQueryInstance(id, beans));
    }
}
