/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.io.Serializable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

import robbie.dao.DaoUtil;
import robbie.dao.Query;

import robbie.util.CollectionsUtil;
import robbie.util.InstanceFactory;

/**
 * XML`XQueryCX^X쐬ĊǗNX.<p>
 */
public class XQueryFactory implements Serializable {

    private static final long serialVersionUID = -6764060726649666359L;

    private static final Log LOG = LogFactory.getLog(XQueryFactory.class);
    
    /** XQuerỹNX */
    protected String xQueryClassName = XQuery.class.getName();
    
    /** query-listosqlvfMap */
    protected Map sqlMap = null;

    /**
     * query-listElementsqlMap쐬B<p>
     * ͓̏܂B
     * @param queryElement query-listElement
     */
    public void configure(Element queryElement) {
        
        Map map = CollectionsUtil.createMap();
        List eleList = queryElement.getChildren("query");
        for (Iterator it=eleList.iterator(); it.hasNext(); ) {
            Element child = (Element)it.next();
            String id = child.getAttributeValue("id");
            if (map.containsKey(id) && LOG.isDebugEnabled()) {
                LOG.warn("x! queryid=[" + id + "]͊ɒ`݂܂. Vŏ㏑܂.");
            }
            map.put(id, child);
        }
        this.sqlMap = map;
        
        if (LOG.isDebugEnabled()) {
            LOG.debug("XQuery̒`Map:" + this.sqlMap);
        }
    }
    
    /**
     * w肳ꂽIDƃp[^MapQueryIuWFNgԂ܂B<p>
     * @param id
     * @param params
     * @return Query
     * @deprecated
     */
    public Query createQueryInstance(String id, Map params) {
        
        XQuery query = (XQuery)InstanceFactory.createInstance(this.xQueryClassName);
        query.setElement((Element)sqlMap.get(id));
        query.setParameters(params);
        query.configure();
        return query;
    }
    
    /**
     * w肳ꂽIDJavaBeansQueryIuWFNgԂ܂B<p>
     * @param id
     * @param beans
     * @return Query
     * @since 1.3.0
     */
    public Query createQueryInstance(String id, Object beans) {
        
        Map params = null;
        try {
            if (beans != null) {
                params = DaoUtil.beansToMap(beans);
            }
        } catch (Exception ex) {
            // Ȃ
        }
        XQuery query = (XQuery)InstanceFactory.createInstance(this.xQueryClassName);
        query.setElement((Element)sqlMap.get(id));
        query.setParameters(params);
        query.configure();
        return query;
    }
}
