/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.rmi.PortableRemoteObject;

/**
 * JNDI֘Ã[eBeBNXB<p>
 */
public class JndiUtil {
    
    private JndiUtil() {}
    
    /**
     * JNDIɎw肵NameObjectoChB<p>
     * @param jhdiName
     * @param obj
     * @throws NamingException
     */
    public static void setJNDIValue(String jhdiName, Object obj)
        throws NamingException {
        
        InitialContext context = null;
        try {
            context = new InitialContext();
            context.rebind(jhdiName, obj);
        } finally {
            if (context != null) {
                context.close();
            }
        }
    }
    
    /**
     * JNDIɓo^Ăw肵ÕIuWFNg擾B<p>
     * @param jndiName
     * @return Object
     * @throws NamingException
     */
    public static Object getJNDIValue(String jndiName) 
        throws NamingException {
        
        Object obj = null;
        InitialContext context = null;
        try {
            context = new InitialContext();
            obj = context.lookup(jndiName);
        } finally {
            if (context != null) {
                context.close();
            }
        }
        return obj;
    }
    
    /**
     * JNDIɓo^Ăw肵ÕIuWFNg擾B<p>
     * 擾ʂw肵NXɃLXg\؂ĂCX^XԂB
     * @param jndiName
     * @param classObj
     * @return Object
     * @throws NamingException
     */
    public static Object getJNDIValue(String jndiName, Class classObj) 
        throws NamingException {
        
        Object obj = getJNDIValue(jndiName);
        return PortableRemoteObject.narrow(obj, classObj);
    
    }
    
}
