/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import jp.robotbrain.framework.Current;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.Tag;

public class CandleStick
extends IndexPoint
implements Current {
    private static final long serialVersionUID = 1L;
    private final double m_open;
    private final double m_high;
    private final double m_low;
    private final double m_close;

    public CandleStick(Tag p_tag, double p_open, double p_high, double p_low, double p_close) {
        super(p_tag, p_close);
        this.m_open = p_open;
        this.m_high = p_high;
        this.m_low = p_low;
        this.m_close = p_close;
    }

    public double getOpen() {
        return this.m_open;
    }

    public double getHigh() {
        return this.m_high;
    }

    public double getLow() {
        return this.m_low;
    }

    public double getClose() {
        return this.m_close;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    public double getAvg() {
        return (this.getHigh() + this.getLow() + this.getClose()) / 3.0;
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,Open,High,Low,Close,Avg");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getString() + "'," + this.getOpen() + "," + this.getHigh() + "," + this.getLow() + "," + this.getClose() + "," + this.getAvg());
    }
}

