/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.Tag;

public class BollingerBand
extends IndexObject {
    private static final long serialVersionUID = 1L;
    private final double m_center;
    private final double m_stdev;
    private final double m_sigmaHigh;
    private final double m_sigmaLow;

    public BollingerBand(Tag p_tag, double p_center, double p_stdev, double p_sigmaHigh, double p_sigmaLow) {
        super(p_tag);
        this.m_center = p_center;
        this.m_stdev = p_stdev;
        this.m_sigmaHigh = p_sigmaHigh;
        this.m_sigmaLow = p_sigmaLow;
    }

    public double getCenter() {
        return this.m_center;
    }

    public double getHigh() {
        return this.m_center + this.m_stdev * this.m_sigmaHigh;
    }

    public double getLow() {
        return this.m_center - this.m_stdev * this.m_sigmaLow;
    }

    public IndexPoint getCenterPoint() {
        return new IndexPoint(this.getTag(), this.m_center);
    }

    public IndexPoint getHighPoint() {
        double v = this.m_center + this.m_stdev * this.m_sigmaHigh;
        return new IndexPoint(this.getTag(), v);
    }

    public IndexPoint getLowPoint() {
        double v = this.m_center - this.m_stdev * this.m_sigmaLow;
        return new IndexPoint(this.getTag(), v);
    }

    @Override
    public void printHeader(PrintStream p_out) {
        p_out.println("Tag,Low,Center,High");
    }

    @Override
    public void print(PrintStream p_out) {
        p_out.println("'" + this.getTag().getString() + "'," + this.getLow() + "," + this.getCenter() + "," + this.getHigh());
    }
}

