/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.ChannelLowLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="ChannelLowLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelLowLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final ChannelLowLine m_channelLowLine;

    public ChannelLowLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
        super(p_label);
        Gene ccountGene = p_geneList.getGene(p_ccountLabel);
        int ccount = ccountGene.getIntValue();
        this.m_channelLowLine = new ChannelLowLine(ccount);
    }

    public void enter(CandleStickList p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_channelLowLine.size();
        this.m_channelLowLine.addPoint((CandleStickList)p_indexObjectList);
        if (this.m_channelLowLine.size() > prevSize) {
            this.notifyIndexNext(this.m_channelLowLine);
        }
    }

    public ChannelLowLine getValues() {
        return this.m_channelLowLine;
    }
}

