/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import jp.robotbrain.net.Cookie;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.HttpHeader;

public class CookieList {
    private ArrayList<Cookie> m_cookieList = new ArrayList();

    protected final HttpHeader createRequestCookie(String p_url, String p_charset) throws CookieException {
        String cookies = "";
        for (Cookie cookie : this.m_cookieList) {
            if (cookie.isSecure() && !p_url.substring(0, 8).equals("https://") || !cookie.getDomain().equals("") && p_url.indexOf(cookie.getDomain()) == -1 || !cookie.getPath().equals("") && p_url.indexOf(cookie.getPath()) == -1) continue;
            try {
                if (cookies.equals("")) {
                    cookies = String.valueOf(cookies) + cookie.getName() + "=" + cookie.getEncodeValue(p_charset);
                    continue;
                }
                cookies = String.valueOf(cookies) + ";" + cookie.getName() + "=" + cookie.getEncodeValue(p_charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new CookieException("createRequestCookie Encode Error URL=" + p_url + " charset=" + p_charset + " value=" + cookie.getValue() + ": " + e.getMessage());
            }
        }
        if (cookies.equals("")) {
            return null;
        }
        return new HttpHeader("Cookie", cookies);
    }

    protected final void importResponseCookie(String p_originUrl, String p_setCookieHeader) throws CookieException {
        try {
            Cookie cookie = this.parseCookie(p_originUrl, p_setCookieHeader);
            URL url = new URL(cookie.getOriginUrl());
            if (cookie.getDomain().equals("")) {
                cookie.setDomain(url.getHost());
            }
            if (p_originUrl.indexOf(cookie.getDomain()) == -1) {
                cookie.setDomain(url.getHost());
            }
            if (!cookie.getName().equals("") && !cookie.getValue().equals("")) {
                int index = this.m_cookieList.indexOf(cookie);
                if (index == -1) {
                    this.m_cookieList.add(cookie);
                } else {
                    this.m_cookieList.remove(index);
                    this.m_cookieList.add(cookie);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new CookieException("importResponseCookie Error p_originUrl=" + p_originUrl + " Set-Cookie=" + p_setCookieHeader + " :" + e.getMessage());
        }
    }

    private final Cookie parseCookie(String p_originUrl, String p_setCookieHeader) {
        Cookie returnValue = new Cookie();
        String[] items = p_setCookieHeader.split(";");
        if (items == null) {
            return null;
        }
        returnValue.setOriginUrl(p_originUrl);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null) {
                if (item.indexOf("=") == -1) {
                    if (item.trim().equalsIgnoreCase("Secure")) {
                        returnValue.setSecure(true);
                    }
                } else {
                    String[] fields = item.split("=");
                    if (fields.length >= 2 && fields[0] != null && fields[1] != null) {
                        String fieldName = fields[0].trim();
                        String fieldValue = fields[1].trim();
                        if (fieldName.equalsIgnoreCase("Expires")) {
                            returnValue.setExpires(fieldValue);
                        } else if (fieldName.equalsIgnoreCase("Domain")) {
                            returnValue.setDomain(fieldValue);
                        } else if (fieldName.equalsIgnoreCase("Path")) {
                            returnValue.setPath(fieldValue);
                        } else if (!fieldName.equals("") && !fieldValue.equals("")) {
                            returnValue.setName(fieldName);
                            returnValue.setValue(fieldValue);
                        }
                    }
                }
            }
            ++n2;
        }
        return returnValue;
    }
}

