/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import jp.robotbrain.html.HtmlForm;
import jp.robotbrain.html.HtmlFormException;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.CookieList;
import jp.robotbrain.net.HttpHeader;
import jp.robotbrain.net.HttpHeaderList;
import jp.robotbrain.net.HttpRecvException;
import jp.robotbrain.net.HttpSendException;

public class Web {
    private URL m_url;
    private HttpURLConnection m_connection;
    private boolean m_autoRedirects = false;
    private String m_lineSeparator = System.getProperty("line.separator");
    private CookieList m_cookieList = new CookieList();
    private HttpHeaderList m_httpHeaderList = new HttpHeaderList();

    public String getHtml(String p_URL, String p_charset, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeader cookieHeader;
        HttpHeaderList reqHeader = new HttpHeaderList();
        if (p_httpHeaderList != null) {
            reqHeader.addList(p_httpHeaderList);
        }
        if ((cookieHeader = this.m_cookieList.createRequestCookie(p_URL, p_charset)) != null) {
            reqHeader.add(cookieHeader);
        }
        try {
            this.setURL(p_URL);
            if (reqHeader != null) {
                this.setRequestProperties(reqHeader);
            }
            this.doGet();
            if (this.getStatusCode() >= 400) {
                throw new IOException("getHtml HttpError HttpStatusCode=" + this.getStatusCode());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpSendException("getHtml SendError URL=" + p_URL + " :" + e.getMessage());
        }
        String returnValue = "";
        try {
            returnValue = this.getResponseText(p_charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpRecvException("getHtml RecvError URL=" + p_URL + " :" + e.getMessage());
        }
        this.importResponseCookie();
        return returnValue;
    }

    public InputStream getHtmlStream(String p_URL, String p_charset, HttpHeaderList p_httpHeaderList) throws IOException {
        this.setURL(p_URL);
        if (p_httpHeaderList != null) {
            this.setRequestProperties(p_httpHeaderList);
        }
        this.doGet();
        if (this.getStatusCode() >= 400) {
            throw new IOException("HttpStatusCode=" + this.getStatusCode());
        }
        return this.getResponseStream();
    }

    public String postHtml(String p_URL, String p_queryString, String p_charset, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeader cookieHeader;
        HttpHeaderList reqHeader = new HttpHeaderList();
        if (p_httpHeaderList != null) {
            reqHeader.addList(p_httpHeaderList);
        }
        if ((cookieHeader = this.m_cookieList.createRequestCookie(p_URL, p_charset)) != null) {
            reqHeader.add(cookieHeader);
        }
        try {
            this.setURL(p_URL);
            if (reqHeader != null) {
                this.setRequestProperties(reqHeader);
            }
            this.doPost(p_queryString);
            if (this.getStatusCode() >= 400) {
                throw new HttpSendException("postHtml HttpError URL=" + p_URL + " QueryString=" + p_queryString + " HttpStatusCode=" + this.getStatusCode());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpSendException("postHtml SendError URL=" + p_URL + " QueryString=" + p_queryString + " :" + e.getMessage());
        }
        String returnValue = "";
        try {
            returnValue = this.getResponseText(p_charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpRecvException("postHtml RecvError URL=" + p_URL + " QueryString=" + p_queryString + " :" + e.getMessage());
        }
        this.importResponseCookie();
        return returnValue;
    }

    public byte[] getImage(String p_URL, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException {
        byte[] returnValue;
        try {
            this.setURL(p_URL);
            if (p_httpHeaderList != null) {
                this.setRequestProperties(p_httpHeaderList);
            }
            this.doGet();
            if (this.getStatusCode() != 200) {
                throw new IOException("HttpStatusCode=" + this.getStatusCode());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpSendException(e.getMessage());
        }
        try {
            returnValue = this.getResponseBinary();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpRecvException(e.getMessage());
        }
        return returnValue;
    }

    private void setURL(String p_URL) throws IOException {
        this.m_url = new URL(p_URL);
        this.m_connection = (HttpURLConnection)this.m_url.openConnection();
        if (!this.m_autoRedirects) {
            this.m_connection.setInstanceFollowRedirects(false);
        }
    }

    private void doGet() throws IOException {
        this.m_connection.setRequestMethod("GET");
        this.m_connection.connect();
    }

    private void setRequestProperties(HttpHeaderList p_httpHeaderList) {
        int i = 0;
        while (i < p_httpHeaderList.size()) {
            HttpHeader hd = p_httpHeaderList.get(i);
            this.m_connection.setRequestProperty(hd.getName(), hd.getValue());
            ++i;
        }
    }

    private void doPost(String p_queryString) throws IOException {
        this.m_connection.setRequestMethod("POST");
        this.setRequestMessage(p_queryString);
        this.m_connection.connect();
    }

    private void setRequestMessage(String p_queryString) throws IOException {
        this.m_connection.setDoOutput(true);
        this.m_connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.m_connection.setRequestProperty("Content-Length", Integer.toString(p_queryString.length()));
        BufferedWriter outer = new BufferedWriter(new OutputStreamWriter(this.m_connection.getOutputStream()));
        outer.write(p_queryString);
        outer.flush();
        outer.close();
    }

    public int getStatusCode() throws IOException {
        if (this.m_connection == null) {
            return -1;
        }
        return this.m_connection.getResponseCode();
    }

    public void printHttpHeaderList() throws IOException {
        if (this.m_connection == null) {
            return;
        }
        int i = 0;
        String name = "";
        String value = "";
        while (true) {
            name = this.m_connection.getHeaderFieldKey(++i);
            value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            System.out.println(String.valueOf(name) + ":" + value);
        }
    }

    private void importResponseCookie() throws CookieException {
        if (this.m_connection == null) {
            return;
        }
        int i = 0;
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            if (name != null && name.equalsIgnoreCase("Set-Cookie")) {
                this.m_cookieList.importResponseCookie(this.getURL(), value);
            }
            ++i;
        }
    }

    @Deprecated
    public HttpHeader createCookie() {
        if (this.m_connection == null) {
            return null;
        }
        HttpHeaderList cookies = this.getCookieList();
        String value = this.extractCookieString(cookies);
        return new HttpHeader("Cookie", value);
    }

    @Deprecated
    private HttpHeaderList getCookieList() {
        if (this.m_connection == null) {
            return null;
        }
        int i = 0;
        HttpHeaderList returnValue = new HttpHeaderList();
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            if (name != null && name.equals("Set-Cookie")) {
                returnValue.add(new HttpHeader(name, value));
            }
            ++i;
        }
        return returnValue;
    }

    @Deprecated
    private String extractCookieString(HttpHeaderList p_cookieList) {
        String returnValue = "";
        int i = 0;
        while (i < p_cookieList.size()) {
            HttpHeader cookie = p_cookieList.get(i);
            int delimit = cookie.getValue().indexOf(";");
            returnValue = String.valueOf(returnValue) + cookie.getValue().substring(0, delimit) + ";";
            ++i;
        }
        return returnValue;
    }

    public String getResponseHeaderValue(String p_name) {
        if (this.m_connection == null) {
            return "";
        }
        int i = 0;
        while (true) {
            String name = this.m_connection.getHeaderFieldKey(i);
            String value = this.m_connection.getHeaderField(i);
            if (value == null) break;
            if (name != null && name.equals(p_name)) {
                return value;
            }
            ++i;
        }
        return "";
    }

    private InputStream getResponseStream() throws IOException {
        return this.m_connection.getInputStream();
    }

    private String getResponseText(String p_charCode) throws IOException {
        BufferedReader inner = new BufferedReader(new InputStreamReader(this.getResponseStream(), p_charCode));
        String response = "";
        String line = "";
        while ((line = inner.readLine()) != null) {
            response = String.valueOf(response) + line + this.m_lineSeparator;
        }
        inner.close();
        return response;
    }

    private byte[] getResponseBinary() throws IOException {
        byte[] response = new byte[1024];
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        int readByte = 0;
        InputStream inner = this.getResponseStream();
        while ((readByte = inner.read(response)) != -1) {
            bs.write(response, 0, readByte);
        }
        inner.close();
        return bs.toByteArray();
    }

    public String sendForm(String p_URL, String p_charset, HtmlForm p_htmlForm) throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
        HttpHeaderList httpHeaderList = new HttpHeaderList();
        httpHeaderList.addList(this.m_httpHeaderList);
        HttpHeader httpHeader = this.getReferer();
        if (httpHeader != null) {
            httpHeaderList.add(httpHeader);
        }
        return this.sendForm(p_URL, p_charset, httpHeaderList, p_htmlForm);
    }

    public String sendForm(String p_URL, String p_charset, HttpHeaderList p_httpHeaderList, HtmlForm p_htmlForm) throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
        if (p_htmlForm.getAction().length() <= 0) {
            return null;
        }
        String returnValue = "";
        if (p_htmlForm.getMethod().equals("post")) {
            try {
                String queryString = p_htmlForm.createQueryString(p_charset);
                returnValue = this.postHtml(p_URL, queryString, p_charset, p_httpHeaderList);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                p_htmlForm.print(System.out);
                throw new HttpSendException("sendForm POST createQueryString Error: " + e.getMessage());
            }
        }
        try {
            String getUrl = String.valueOf(p_URL) + "?" + p_htmlForm.createQueryString(p_charset);
            returnValue = this.getHtml(getUrl, p_charset, p_httpHeaderList);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            p_htmlForm.print(System.out);
            throw new HttpSendException("sendForm GET createQueryString Error: " + e.getMessage());
        }
        String redirect = this.redirectHtml(p_charset, p_httpHeaderList);
        if (!redirect.equals("")) {
            return redirect;
        }
        return returnValue;
    }

    public String go(String p_URL, String p_charset) throws HttpSendException, HttpRecvException, CookieException {
        HttpHeaderList httpHeaderList = new HttpHeaderList();
        httpHeaderList.addList(this.m_httpHeaderList);
        HttpHeader httpHeader = this.getReferer();
        if (httpHeader != null) {
            httpHeaderList.add(httpHeader);
        }
        return this.go(p_URL, p_charset, httpHeaderList);
    }

    public String go(String p_URL, String p_charset, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        String returnValue = this.getHtml(p_URL, p_charset, p_httpHeaderList);
        String redirect = this.redirectHtml(p_charset, p_httpHeaderList);
        if (!redirect.equals("")) {
            return redirect;
        }
        return returnValue;
    }

    private HttpHeader getReferer() {
        String prevUrl = this.getURL();
        if (prevUrl == null) {
            return null;
        }
        if (prevUrl.equals("")) {
            return null;
        }
        return new HttpHeader("Referer", prevUrl);
    }

    public String redirectHtml(String p_charset, HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
        String nextUrl;
        String returnValue = "";
        while (!(nextUrl = this.getResponseHeaderValue("Location")).equals("")) {
            returnValue = this.getHtml(nextUrl, p_charset, p_httpHeaderList);
        }
        return returnValue;
    }

    public void close() {
        this.m_connection.disconnect();
    }

    public String getURL() {
        if (this.m_connection == null) {
            return null;
        }
        return this.m_connection.getURL().toString();
    }

    public String getDirectry() {
        if (this.m_connection == null) {
            return null;
        }
        if (this.m_connection.getURL().toString().lastIndexOf("/") < 8) {
            return this.m_connection.getURL().toString();
        }
        return this.m_connection.getURL().toString().substring(0, this.m_connection.getURL().toString().lastIndexOf("/"));
    }

    @Deprecated
    public void setAutoRedirects(boolean p_autoRedirects) {
        this.m_autoRedirects = p_autoRedirects;
    }

    @Deprecated
    public boolean isAutoRedirects() {
        return this.m_autoRedirects;
    }

    public HttpHeaderList getHttpHeaderList() {
        return this.m_httpHeaderList;
    }
}

