/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.BollingerBandList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="BollingerBandList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountCenter", "pcountStdev", "sigmaHigh", "sigmaLow"})
public class BollingerBandListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final BollingerBandList m_bollingerBandList;

    public BollingerBandListStream(String p_label, GeneList p_geneList, String p_pcountCenterLabel, String p_pcountStdevLabel, String p_sigmaHighLabel, String p_sigmaLowLabel) throws GeneListException {
        super(p_label);
        Gene pcountCenterGene = p_geneList.getGene(p_pcountCenterLabel);
        Gene pcountStdevGene = p_geneList.getGene(p_pcountStdevLabel);
        Gene sigmaHighGene = p_geneList.getGene(p_sigmaHighLabel);
        Gene sigmaLowGene = p_geneList.getGene(p_sigmaLowLabel);
        int pcountCenter = pcountCenterGene.getIntValue();
        int pcountStdev = pcountStdevGene.getIntValue();
        double sigmaHigh = sigmaHighGene.getDoubleValue();
        double sigmaLow = sigmaLowGene.getDoubleValue();
        this.m_bollingerBandList = new BollingerBandList(pcountCenter, pcountStdev, sigmaHigh, sigmaLow);
    }

    public void enter(IndexLine p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndex(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (p_indexObjectList == null) {
            throw new IndexStreamException("Null Error");
        }
        if (!(p_indexObjectList instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        if (p_indexObjectList.size() <= 0) {
            return;
        }
        int prevSize = this.m_bollingerBandList.size();
        this.m_bollingerBandList.addObject((IndexLine)p_indexObjectList);
        if (this.m_bollingerBandList.size() > prevSize) {
            this.notifyIndexNext(this.m_bollingerBandList);
        }
    }

    public BollingerBandList getValues() {
        return this.m_bollingerBandList;
    }
}

