/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.robotbrain.signal.IndexObject;

public class IndexObjectList<T extends IndexObject>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<T> m_objectList;

    protected IndexObjectList() {
        this.m_objectList = new ArrayList();
    }

    private IndexObjectList(List<T> p_src) {
        this.m_objectList = new ArrayList<T>(p_src);
    }

    protected IndexObjectList(IndexObjectList<T> p_src) {
        this.m_objectList = new ArrayList<T>(p_src.m_objectList);
    }

    public final T get(int p_no) {
        if (this.size() <= 0) {
            return null;
        }
        if (this.size() <= p_no) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(p_no));
    }

    public final T getLast() {
        if (this.size() <= 0) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(this.m_objectList.size() - 1));
    }

    public final T getPrev(int p_count) {
        int prevIndex = this.size() - p_count - 1;
        if (prevIndex < 0) {
            return null;
        }
        if (prevIndex >= this.size()) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(prevIndex));
    }

    public final IndexObjectList<T> getMidList(int p_countBack, int p_countList) {
        int to;
        int from = this.size() - p_countBack;
        if (from >= (to = this.size() - (p_countList - 1))) {
            return null;
        }
        List<T> sub = this.m_objectList.subList(from, to);
        return new IndexObjectList<T>(sub);
    }

    public final IndexObjectList<T> getTailList(int p_count) {
        if (this.size() < p_count) {
            return null;
        }
        List<T> sub = this.m_objectList.subList(this.size() - p_count, this.size());
        return new IndexObjectList<T>(sub);
    }

    public void remove(String p_date) {
        ArrayList<IndexObject> newList = new ArrayList<IndexObject>();
        int i = 0;
        while (i < this.m_objectList.size()) {
            IndexObject obj = (IndexObject)this.m_objectList.get(i);
            if (obj.getTag().getDate().equals(p_date)) {
                this.m_objectList.set(i, null);
            } else {
                newList.add(obj);
            }
            ++i;
        }
        this.m_objectList = newList;
    }

    protected final ArrayList<T> getObjectList() {
        return this.m_objectList;
    }

    protected void add(T p_src) {
        if (p_src == null) {
            return;
        }
        this.m_objectList.add(p_src);
    }

    public final boolean isExist() {
        if (this.size() <= 0) {
            return false;
        }
        T p = this.m_objectList.get(0);
        return p != null;
    }

    public final int size() {
        return this.m_objectList.size();
    }

    public final void print(PrintStream p_out) {
        if (this.size() <= 0) {
            return;
        }
        ((IndexObject)this.getLast()).printHeader(p_out);
        for (IndexObject o : this.m_objectList) {
            o.print(p_out);
        }
    }

    public final void print(PrintStream p_out, String p_date) {
        if (this.size() <= 0) {
            return;
        }
        ((IndexObject)this.getLast()).printHeader(p_out);
        for (IndexObject o : this.m_objectList) {
            if (!o.getTag().getDate().equals(p_date)) continue;
            o.print(p_out);
        }
    }

    public final String toXml() {
        if (this.size() <= 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        for (IndexObject o : this.m_objectList) {
            returnValue.append(o.toXml());
        }
        return returnValue.toString();
    }
}

