/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.LevelDesign;
import jp.robotbrain.signal.LevelDesignList;

public class LevelLine
extends IndexLine {
    private static final long serialVersionUID = 1L;
    private LevelDesignList m_levelDesignList = new LevelDesignList();

    public void setLevelDesignList(LevelDesignList p_levelDesignList) {
        this.m_levelDesignList = p_levelDesignList;
    }

    protected int getLevelByValue(double p_value) {
        int i = 0;
        while (i < this.m_levelDesignList.size()) {
            LevelDesign il = this.m_levelDesignList.getLevelDesign(i);
            if (il.getBegin() < p_value && il.getEnd() >= p_value) {
                return il.getLevel();
            }
            ++i;
        }
        if (this.m_levelDesignList.getMax().getEnd() < p_value) {
            return this.m_levelDesignList.getMax().getLevel() + 1;
        }
        if (this.m_levelDesignList.getMin().getBegin() >= p_value) {
            return this.m_levelDesignList.getMin().getLevel() - 1;
        }
        return -1;
    }

    public void addPoint(IndexPoint p_src) {
        if (p_src == null) {
            return;
        }
        double value = this.getLevelByValue(p_src.getValue());
        IndexPoint p = new IndexPoint(p_src.getTag(), value);
        this.add(p);
    }
}

