/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.EventSignalBlock;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TypeSignalBlock;

@TypeSignalBlock
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"timerMinute"})
@InputComponentList(values={"@Signal"})
public class TimerSignalBlock
extends EventSignalBlock {
    private Tag m_beginTimeTag = null;
    private Tag m_endTimeTag = null;
    private int m_timerMinute;

    public TimerSignalBlock(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList, String p_timerMinuteLabel) throws GeneListException {
        super(p_label, p_priority, p_outputSignal);
        this.m_timerMinute = p_geneList.getGene(p_timerMinuteLabel).getIntValue();
    }

    @Override
    public JudgmentResult getJudgmentResult() throws IndexStreamException {
        Tag inputTag = this.getInputTag();
        if (inputTag == null) {
            return new JudgmentResult(null, NmSignal.NOSIGNAL);
        }
        JudgmentResult returnValue = new JudgmentResult(inputTag, NmSignal.NOSIGNAL);
        if (this.m_beginTimeTag != null && this.m_endTimeTag != null && this.m_endTimeTag.calcTimeDifference(inputTag) > 0L) {
            this.m_beginTimeTag = null;
            this.m_endTimeTag = null;
        }
        if (this.m_beginTimeTag == null) {
            JudgmentResult inputSignal = super.getJudgmentResult();
            if (inputSignal.getSignal() == NmSignal.LONG || inputSignal.getSignal() == NmSignal.SHORT) {
                this.m_beginTimeTag = inputTag;
            }
        } else if (this.m_endTimeTag == null) {
            if (this.m_beginTimeTag.calcTimeDifference(inputTag) >= (long)(this.m_timerMinute * 60)) {
                this.m_endTimeTag = inputTag;
                returnValue = new JudgmentResult(inputTag, this.getOutputSignal());
            }
        } else {
            returnValue = new JudgmentResult(inputTag, this.getOutputSignal());
        }
        this.setDetails(returnValue.getSignal().toString());
        return returnValue;
    }
}

