/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;

public class UtilSignal {
    private UtilSignal() {
    }

    public static double calcAvg(IndexLine p_src) {
        double sum = 0.0;
        int i = 0;
        while (i < p_src.size()) {
            sum += ((IndexPoint)p_src.get(i)).getValue();
            ++i;
        }
        if (p_src.size() == 0) {
            return 0.0;
        }
        return sum / (double)p_src.size();
    }

    public static double calcStdev(IndexLine p_src) {
        double sum = 0.0;
        double avg = UtilSignal.calcAvg(p_src);
        int i = 0;
        while (i < p_src.size()) {
            double v = ((IndexPoint)p_src.get(i)).getValue();
            sum += (v - avg) * (v - avg);
            ++i;
        }
        if (p_src.size() == 0) {
            return 0.0;
        }
        return Math.sqrt(sum / (double)p_src.size());
    }

    public static double calcTrueRange(CandleStick p_prevCandleStick, CandleStick p_currentCandleStick) {
        double trA = p_currentCandleStick.getHigh() - p_currentCandleStick.getLow();
        double trB = p_currentCandleStick.getHigh() - p_prevCandleStick.getClose();
        double trC = p_prevCandleStick.getClose() - p_currentCandleStick.getLow();
        double trMax = 0.0;
        trMax = trA > trB ? (trA < trC ? trC : trA) : (trB < trC ? trC : trB);
        return trMax;
    }
}

