/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.LiteralLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="LiteralLine")
@InputComponentList(values={"@IndexObjectList"})
@GeneDefaultLabelList(values={"literalValue"})
public class LiteralLineStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final LiteralLine m_literalLine;

    public LiteralLineStream(String p_label, GeneList p_geneList, String p_literalValueLabel) throws GeneListException {
        super(p_label);
        Gene literalValueGene = p_geneList.getGene(p_literalValueLabel);
        double literalValue = literalValueGene.getDoubleValue();
        this.m_literalLine = new LiteralLine(literalValue);
    }

    public void enter(IndexObjectList<?> p_src) throws IndexStreamException {
        this.notifyIndex(p_src);
    }

    @Override
    public void notifyIndexSub(IndexObjectList<?> p_indexObjectList) throws IndexStreamException {
        if (!(p_indexObjectList instanceof IndexObjectList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_literalLine.addPoint(p_indexObjectList);
        this.notifyIndexNext(this.m_literalLine);
    }

    public LiteralLine getValues() {
        return this.m_literalLine;
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public void economizeCapacity() {
        this.m_literalLine.setCapacity(this.getDestinationMaxCost());
    }
}

