/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.common;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UtilString {
    private UtilString() {
    }

    public static String findFirstRegexKeyword(String p_src, String p_regex, int p_seq) {
        String returnValue = "";
        Pattern p = Pattern.compile(p_regex, 34);
        Matcher m = p.matcher(p_src);
        if (m.find()) {
            returnValue = m.group(p_seq);
        }
        return returnValue;
    }

    public static String findLastRegexKeyword(String p_src, String p_regex, int p_seq) {
        String returnValue = "";
        Pattern p = Pattern.compile(p_regex, 34);
        Matcher m = p.matcher(p_src);
        while (m.find()) {
            returnValue = m.group(p_seq);
        }
        return returnValue;
    }

    public static String replace(String p_src, String p_regex, String p_replacement) {
        Pattern p = Pattern.compile(p_regex);
        Matcher m = p.matcher(p_src);
        return m.replaceAll(p_replacement);
    }

    public static String toWideNumber(String p_src) {
        StringBuilder sb = new StringBuilder(p_src);
        int i = 0;
        while (i < p_src.length()) {
            char c = p_src.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.setCharAt(i, (char)(c - 48 + 65296));
            }
            ++i;
        }
        return sb.toString();
    }

    public static Object toObject(String p_srcXML) throws IOException {
        ByteArrayInputStream inStr = new ByteArrayInputStream(p_srcXML.getBytes());
        BufferedInputStream inBuf = new BufferedInputStream(inStr);
        XMLDecoder inXml = new XMLDecoder(inBuf);
        Object returnValue = inXml.readObject();
        inXml.close();
        inBuf.close();
        ((InputStream)inStr).close();
        return returnValue;
    }

    public static String toXML(Object p_src) throws IOException {
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        XMLEncoder outXml = new XMLEncoder(outStr);
        outXml.writeObject(p_src);
        outXml.close();
        byte[] returnValue = outStr.toByteArray();
        outStr.close();
        return new String(returnValue);
    }

    public static String trimEnd(String p_src, String p_trimString) {
        String returnValue = p_src;
        while (returnValue.endsWith(p_trimString)) {
            returnValue = returnValue.substring(0, returnValue.length() - p_trimString.length());
        }
        return returnValue;
    }

    public static int getScaleLength(String p_src) {
        if (p_src == null) {
            return 0;
        }
        String value = p_src.trim();
        if (value.length() < 2) {
            return 0;
        }
        int p = value.indexOf(".");
        if (p < 1) {
            return 0;
        }
        String sscale = value.substring(p + 1);
        if (Double.parseDouble(sscale) == 0.0) {
            return 0;
        }
        sscale = UtilString.trimEnd(sscale, "0");
        return sscale.length();
    }

    public static int getIntLength(String p_src) {
        if (p_src == null) {
            return 0;
        }
        String value = p_src.trim();
        int p = value.indexOf(".");
        if (p < 1) {
            return value.length();
        }
        String sscale = value.substring(0, p);
        if (Double.parseDouble(sscale) == 0.0) {
            return 0;
        }
        return sscale.length();
    }
}

