/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.robotbrain.html.HtmlForm;
import jp.robotbrain.html.HtmlFormList;
import jp.robotbrain.html.HtmlFrameException;
import jp.robotbrain.html.HtmlHref;
import jp.robotbrain.html.HtmlHrefException;
import jp.robotbrain.html.HtmlInput;
import jp.robotbrain.html.HtmlInputList;
import jp.robotbrain.html.HtmlOption;
import jp.robotbrain.html.HtmlOptionList;
import jp.robotbrain.html.HtmlSelect;
import jp.robotbrain.html.HtmlSelectList;

public class HtmlParser {
    private HtmlParser() {
    }

    public static HtmlFormList parseHtmlForm(String p_html) {
        p_html = p_html.replaceAll("[\r\n]", "");
        HtmlFormList returnValue = new HtmlFormList();
        ArrayList<String> formList = HtmlParser.extractStringList("<form(.+?)</form>", p_html, 0);
        int i = 0;
        while (i < formList.size()) {
            String form = formList.get(i);
            String formAttr = HtmlParser.extractString("<form([^>]+?)>", form, 0);
            String name = HtmlParser.getAttr("name", formAttr);
            String method = HtmlParser.getAttr("method", formAttr);
            String action = HtmlParser.getAttr("action", formAttr);
            HtmlInputList htmlInputList = HtmlParser.parseHtmlInput(form);
            HtmlSelectList htmlSelectList = HtmlParser.parseHtmlSelect(form);
            HtmlForm htmlForm = new HtmlForm();
            htmlForm.setName(name);
            htmlForm.setMethod(method);
            htmlForm.setAction(action);
            htmlForm.setHtmlInputList(htmlInputList);
            htmlForm.setHtmlSelectList(htmlSelectList);
            returnValue.add(htmlForm);
            ++i;
        }
        return returnValue;
    }

    private static HtmlInputList parseHtmlInput(String p_html) {
        HtmlInputList returnValue = new HtmlInputList();
        ArrayList<String> inputList = HtmlParser.extractStringList("<(input|button)([^>]+?)>", p_html, 0);
        int j = 0;
        while (j < inputList.size()) {
            String input = inputList.get(j);
            String id = HtmlParser.getAttr("id", input);
            String type = HtmlParser.getAttr("type", input);
            String name = HtmlParser.getAttr("name", input);
            String value = HtmlParser.getAttr("value", input);
            HtmlInput htmlInput = new HtmlInput();
            htmlInput.setId(id);
            htmlInput.setType(type);
            htmlInput.setName(name);
            htmlInput.setValue(value);
            htmlInput.setSelected(false);
            returnValue.add(htmlInput);
            ++j;
        }
        return returnValue;
    }

    private static HtmlSelectList parseHtmlSelect(String p_html) {
        HtmlSelectList returnValue = new HtmlSelectList();
        ArrayList<String> selectList = HtmlParser.extractStringList("<select(.+?)(<select|</select>|</form>)", p_html, 0);
        int i = 0;
        while (i < selectList.size()) {
            String select = selectList.get(i);
            String selectAttr = HtmlParser.extractString("<select([^>]+?)>", select, 0);
            String id = HtmlParser.getAttr("id", selectAttr);
            String name = HtmlParser.getAttr("name", selectAttr);
            HtmlSelect htmlSelect = new HtmlSelect();
            htmlSelect.setId(id);
            htmlSelect.setName(name);
            htmlSelect.setHtmlOptionList(HtmlParser.parseHtmlOption(select));
            returnValue.add(htmlSelect);
            ++i;
        }
        return returnValue;
    }

    private static HtmlOptionList parseHtmlOption(String p_html) {
        HtmlOptionList returnValue = new HtmlOptionList();
        ArrayList<String> optionList = HtmlParser.extractStringList("<option[^<]+", p_html, 0);
        int i = 0;
        while (i < optionList.size()) {
            String optionAttr = optionList.get(i);
            String id = HtmlParser.getAttr("id", optionAttr);
            String value = HtmlParser.getAttr("value", optionAttr);
            String title = HtmlParser.extractString(">(.+)", optionAttr, 1);
            HtmlOption htmlOption = new HtmlOption();
            htmlOption.setId(id);
            htmlOption.setValue(value);
            htmlOption.setTitle(title);
            htmlOption.setSelected(false);
            returnValue.add(htmlOption);
            ++i;
        }
        return returnValue;
    }

    private static String getAttr(String p_attrName, String p_html) {
        String regex = String.valueOf(p_attrName) + "\\b\\s*=\\s*(?:([^<>'\"\\s]+)|'([^']+)'|(\"([^\"]+)\"))[^>]*>";
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(p_html);
        if (m.find()) {
            if (m.group(1) != null) {
                return m.group(1).replaceAll("[\"']", "");
            }
            if (m.group(2) != null) {
                return m.group(2).replaceAll("[\"']", "");
            }
            if (m.group(3) != null) {
                return m.group(3).replaceAll("[\"']", "");
            }
        }
        return "";
    }

    private static String extractString(String p_regex, String p_html, int p_groupIndex) {
        Pattern p = Pattern.compile(p_regex, 34);
        Matcher m = p.matcher(p_html);
        if (m.find()) {
            String returnValue = m.group(p_groupIndex);
            return returnValue;
        }
        return "";
    }

    protected static ArrayList<String> extractStringList(String p_regex, String p_html, int p_groupIndex) {
        Pattern p = Pattern.compile(p_regex, 34);
        Matcher m = p.matcher(p_html);
        ArrayList<String> returnValue = new ArrayList<String>();
        int i = 0;
        while (m.find(i)) {
            String match = m.group(p_groupIndex);
            returnValue.add(match);
            i = m.start() + 1;
        }
        return returnValue;
    }

    public static String parseHtmlHref(String p_linkString, String p_html) throws HtmlHrefException {
        p_html = p_html.replaceAll("[\r\n]", "");
        String regex = "<a\\s.*?\\bhref\\s*?=\\s*?(?:([^<>'\"\\s]+)|'([^']+)'|\"([^\"]+)\")[^>]*?>\\s*?" + p_linkString + "\\s*?<";
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(p_html);
        ArrayList<String> hrefs = new ArrayList<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                hrefs.add(m.group(1).replaceAll("[\"']", ""));
            }
            if (m.group(2) != null) {
                hrefs.add(m.group(2).replaceAll("[\"']", ""));
            }
            if (m.group(3) == null) continue;
            hrefs.add(m.group(3).replaceAll("[\"']", ""));
        }
        if (hrefs.size() <= 0) {
            throw new HtmlHrefException("method:HtmlParser.parseHtmlHref(1) p_linkString=" + p_linkString, p_html);
        }
        if (hrefs.size() > 1) {
            String url1 = (String)hrefs.get(0);
            int i = 1;
            while (i < hrefs.size()) {
                String url2 = (String)hrefs.get(i);
                if (!url1.equals(url2)) {
                    throw new HtmlHrefException("method:HtmlParser.parseHtmlHref(2) p_linkString=" + p_linkString, p_html);
                }
                ++i;
            }
        }
        String returnValue = (String)hrefs.get(0);
        returnValue = returnValue.replaceAll("(?<=&)amp;", "");
        return returnValue;
    }

    public static ArrayList<HtmlHref> parseHtmlHref(String p_html) {
        p_html = p_html.replaceAll("[\r\n]", "");
        String regex = "<a\\s.*?\\bhref\\s*?=\\s*?(?:([^<>'\"\\s]+)|'([^']+)'|\"([^\"]+)\")[^>]*?>\\s*?(.*?)\\s*?<";
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(p_html);
        ArrayList<HtmlHref> returnValue = new ArrayList<HtmlHref>();
        while (m.find()) {
            HtmlHref href = new HtmlHref();
            if (m.group(1) != null) {
                href.setURL(m.group(1).replaceAll("[\"']", ""));
            }
            if (m.group(2) != null) {
                href.setURL(m.group(2).replaceAll("[\"']", ""));
            }
            if (m.group(3) != null) {
                href.setURL(m.group(3).replaceAll("[\"']", ""));
            }
            if (m.group(4) != null) {
                href.setLinkString(m.group(4));
            }
            href.setURL(href.getURL().replaceAll("(?<=&)amp;", ""));
            returnValue.add(href);
        }
        return returnValue;
    }

    public static String parseHtmlFrame(String p_name, String p_html) throws HtmlFrameException {
        p_html = p_html.replaceAll("[\r\n]", "");
        String regex = "<[i]*?frame\\s.*?\\bsrc\\s*?=\\s*?(?:([^<>'\"\\s]+)|'([^']+)'|\"([^\"]+)\")[^>]*?\\s.*?\\bname\\s*?=\\s*?(?:([^<>'\"\\s]+)|'([^']+)'|\"([^\"]+)\").+?</[i]*?frame>";
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(p_html);
        HashMap<String, String> frames = new HashMap<String, String>();
        while (m.find()) {
            ArrayList<String> srcs = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            if (m.group(1) != null) {
                srcs.add(m.group(1).replaceAll("[\"']", ""));
            }
            if (m.group(2) != null) {
                srcs.add(m.group(2).replaceAll("[\"']", ""));
            }
            if (m.group(3) != null) {
                srcs.add(m.group(3).replaceAll("[\"']", ""));
            }
            if (m.group(4) != null) {
                names.add(m.group(4).replaceAll("[\"']", ""));
            }
            if (m.group(5) != null) {
                names.add(m.group(5).replaceAll("[\"']", ""));
            }
            if (m.group(6) != null) {
                names.add(m.group(6).replaceAll("[\"']", ""));
            }
            if (srcs.size() != 1 && names.size() != 1) continue;
            String key = (String)names.get(0);
            String value = (String)srcs.get(0);
            if (frames.containsKey(key)) {
                String existValue = (String)frames.get(key);
                if (existValue.equals(value)) continue;
                throw new HtmlFrameException("method:HtmlParser.parseHtmlFrame(1) p_name=" + p_name);
            }
            frames.put((String)names.get(0), (String)srcs.get(0));
        }
        String returnValue = (String)frames.get(p_name);
        returnValue = returnValue.replaceAll("(?<=&)amp;", "");
        return returnValue;
    }
}

