/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickHighAvgLine;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="CandleStickHighAvgLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"closeRatio"})
public class CandleStickHighAvgLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickHighAvgLine m_candleStickHighAvgLine;

    public CandleStickHighAvgLineStream(String p_label, GeneList p_geneList, String p_closeRatioLabel) throws GeneListException {
        super(p_label);
        Gene closeRatioGene = p_geneList.getGene(p_closeRatioLabel);
        double closeRatio = closeRatioGene.getDoubleValue();
        this.m_candleStickHighAvgLine = new CandleStickHighAvgLine(closeRatio);
        this.getPortList().add("@CandleStickList", 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@CandleStickList");
        if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_candleStickHighAvgLine.addPoint((CandleStick)port.getIndexStream().getValues().getLast());
        return this.notifyIndexNext();
    }

    @Override
    public CandleStickHighAvgLine getValues() {
        return this.m_candleStickHighAvgLine;
    }

    public CandleStickHighAvgLine getViewValues() {
        return this.m_candleStickHighAvgLine;
    }

    @Override
    public void economizeMemory() {
        this.m_candleStickHighAvgLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_candleStickHighAvgLine.setCapacity(capacity);
    }
}

