/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.UtilSignal;

public class EmaLine
extends IndexLine {
    private static final long serialVersionUID = 1L;
    private final int m_pcount;
    private final int m_accumulateCount;

    public EmaLine(int p_pcount) {
        super(NmViewType.INDEXLINE);
        this.m_pcount = p_pcount;
        this.m_accumulateCount = p_pcount;
    }

    public EmaLine(int p_pcount, int p_accumulateCount) {
        super(NmViewType.INDEXLINE);
        this.m_pcount = p_pcount;
        this.m_accumulateCount = p_accumulateCount;
    }

    public void addPoint(IndexLine p_src) {
        if (p_src == null) {
            return;
        }
        if (p_src.size() < this.m_accumulateCount) {
            return;
        }
        if (this.size() <= 0) {
            IndexLine tail = p_src.getTailLine(this.m_pcount);
            double avg = UtilSignal.calcAvg(tail);
            this.add(new IndexPoint(((IndexPoint)p_src.getLast()).getTag(), avg));
        } else {
            double prevValue = ((IndexPoint)this.getLast()).getValue();
            double curValue = ((IndexPoint)p_src.getLast()).getValue();
            double a = 2.0 / ((double)this.m_pcount + 1.0);
            double value = prevValue + a * (curValue - prevValue);
            this.add(new IndexPoint(((IndexPoint)p_src.getLast()).getTag(), value));
        }
    }
}

