/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.IndexStreamPortList;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.signal.TradeComponent;

public abstract class IndexStream
extends TradeComponent {
    private static final long serialVersionUID = 1L;
    private final IndexStreamPortList m_portList = new IndexStreamPortList();
    private final ArrayList<IndexStream> m_destinationList = new ArrayList();
    private Tag m_prevTag;
    private int m_destinationMaxCost;

    public IndexStream(String p_label) {
        super(p_label);
    }

    public final boolean notifyIndex() throws IndexStreamException {
        for (IndexStreamPort port : this.getPortList().values()) {
            if (port.getIndexStream() == null) {
                throw new IndexStreamException("Null Error");
            }
            IndexObjectList<?> idxList = port.getIndexStream().getValues();
            if (idxList == null) {
                throw new IndexStreamException("Null Error");
            }
            if (idxList.size() >= port.getCost()) continue;
            return false;
        }
        return this.notifyIndexSub();
    }

    protected abstract boolean notifyIndexSub() throws IndexStreamException;

    protected boolean isTagChanged() {
        if (this.getValues().size() <= 0) {
            return false;
        }
        Tag tag = ((IndexObject)this.getValues().getLast()).getTag();
        boolean returnValue = !tag.equals(this.m_prevTag);
        return returnValue;
    }

    protected final boolean notifyIndexNext() throws IndexStreamException {
        if (!this.isTagChanged()) {
            return false;
        }
        this.m_prevTag = ((IndexObject)this.getValues().getLast()).getTag();
        if (this.m_destinationList.size() <= 0) {
            return true;
        }
        boolean returnValue = false;
        for (IndexStream i : this.m_destinationList) {
            if (i == null || !i.notifyIndex()) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public abstract IndexObjectList<?> getValues();

    public abstract IndexObjectList<?> getViewValues();

    public final void addDestination(IndexStream p_indexStream, IndexStreamPort p_indexStreamPort) {
        p_indexStreamPort.setIndexStream(this);
        if (p_indexStream != null) {
            this.m_destinationList.add(p_indexStream);
        }
        if (p_indexStreamPort.getCost() > this.m_destinationMaxCost) {
            this.m_destinationMaxCost = p_indexStreamPort.getCost();
        }
    }

    protected void setDestinationMaxCost(int p_destinationMaxCost) {
        this.m_destinationMaxCost = p_destinationMaxCost;
    }

    public int getDestinationMaxCost() {
        return this.m_destinationMaxCost;
    }

    public IndexStreamPortList getPortList() {
        return this.m_portList;
    }

    public final String toXml() {
        if (this.getValues().size() <= 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<component label=\"");
        returnValue.append(this.getLabel());
        returnValue.append("\">");
        returnValue.append(this.getValues().toXml());
        returnValue.append("</component>");
        return returnValue.toString();
    }
}

