/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexLineStream;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.LevelDesign;
import jp.robotbrain.signal.LevelDesignList;
import jp.robotbrain.signal.LevelLine;
import jp.robotbrain.signal.TypeIndexStream;

@TypeIndexStream(value="LevelLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"levelLabelList..."})
public class LevelLineStream
extends IndexLineStream {
    private static final long serialVersionUID = 1L;
    private final LevelLine m_levelLine;

    public LevelLineStream(String p_label, GeneList p_geneList, String ... p_levelLabelList) throws GeneListException {
        super(p_label);
        if (p_levelLabelList == null) {
            throw new GeneListException("p_levelLabelList is null");
        }
        LevelDesignList levelDesignList = new LevelDesignList();
        int level = 0;
        double prevValue = 0.0;
        String[] stringArray = p_levelLabelList;
        int n = p_levelLabelList.length;
        int n2 = 0;
        while (n2 < n) {
            String levelLabel = stringArray[n2];
            Gene levelLabelGene = null;
            if (level == 0) {
                levelLabelGene = p_geneList.getGene(levelLabel);
                levelDesignList.addLevelDesign(new LevelDesign(level, Double.NEGATIVE_INFINITY, levelLabelGene.getDoubleValue()));
            } else {
                levelLabelGene = p_geneList.getGene(levelLabel);
                levelDesignList.addLevelDesign(new LevelDesign(level, prevValue, levelLabelGene.getDoubleValue()));
            }
            ++level;
            prevValue = levelLabelGene.getDoubleValue();
            ++n2;
        }
        this.m_levelLine = new LevelLine();
        this.m_levelLine.setLevelDesignList(levelDesignList);
        this.getPortList().add("@IndexLine", 1);
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        IndexStreamPort port = this.getPortList().get("@IndexLine");
        if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        this.m_levelLine.addPoint((IndexPoint)port.getIndexStream().getValues().getLast());
        return this.notifyIndexNext();
    }

    @Override
    public LevelLine getValues() {
        return this.m_levelLine;
    }

    public LevelLine getViewValues() {
        return this.m_levelLine;
    }

    @Override
    public void economizeMemory() {
        this.m_levelLine.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_levelLine.setCapacity(capacity);
    }
}

