/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledOutputSignal
@InputComponentList(values={"@IndexLine"})
public class RiseSignal
extends SignalStream {
    private static final long serialVersionUID = 1L;

    public RiseSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
        super(p_label, p_priority, p_outputSignal);
        this.getPortList().add("@IndexLine", 2);
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        IndexStreamPort p = this.getPortList().get("@IndexLine");
        if (p == null) {
            throw new IndexStreamException("Port Null Error");
        }
        if (p.getIndexStream() == null) {
            return null;
        }
        if (p.getIndexStream().getValues() == null) {
            return null;
        }
        if (!(p.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("Instance Error");
        }
        IndexLine line = (IndexLine)p.getIndexStream().getValues();
        if (line.size() < 2) {
            return null;
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        if (((IndexPoint)line.getLast()).getValue() > ((IndexPoint)line.getPrev(1)).getValue()) {
            returnValue = this.getOutputSignal();
        } else if (((IndexPoint)line.getLast()).getValue() == ((IndexPoint)line.getPrev(1)).getValue() && this.getLastJudgmentResult() != null) {
            returnValue = this.getLastJudgmentResult().getSignal();
        }
        return new JudgmentResult(((IndexPoint)line.getLast()).getTag(), returnValue);
    }
}

