/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.framework;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import jp.robotbrain.common.UtilCalc;
import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneListException;

public final class GeneList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Gene> m_values = new ArrayList();

    public GeneList clone() throws CloneNotSupportedException {
        GeneList returnValue = new GeneList();
        for (Gene srcg : this.m_values) {
            try {
                returnValue.add(srcg.clone());
            }
            catch (GeneListException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object p_other) {
        if (!(p_other instanceof GeneList)) {
            return false;
        }
        GeneList other = (GeneList)p_other;
        if (this.m_values.size() != other.size()) {
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= this.m_values.size()) {
                    return true;
                }
                Gene meGene = this.m_values.get(i);
                Gene otherGene = other.getGene(i);
                if (meGene.getDoubleValue() != otherGene.getDoubleValue()) {
                    return false;
                }
                ++i;
            }
        }
        catch (GeneListException e) {
            return false;
        }
    }

    public int hashCode() {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append(this.m_values.size());
        int i = 0;
        while (i < this.m_values.size()) {
            Gene meGene = this.m_values.get(i);
            returnValue.append(meGene.getDoubleValue());
            ++i;
        }
        return returnValue.toString().hashCode();
    }

    public GeneList createMutant() throws CloneNotSupportedException, GeneListException {
        GeneList mutant = this.clone();
        int no = UtilCalc.random(this.size() - 1);
        mutant.getGene(no).initRandom();
        return mutant;
    }

    public GeneList createChild(GeneList p_other, double p_heredityRate) throws GeneListException {
        GeneList child = new GeneList();
        int i = 0;
        while (i < this.size()) {
            child.add(UtilCalc.probability(p_heredityRate) ? p_other.getGene(i) : this.getGene(i));
            ++i;
        }
        return child;
    }

    public void initRandom() {
        for (Gene g : this.m_values) {
            g.initRandom();
        }
    }

    public void add(Gene p_gene) throws GeneListException {
        if (this.m_values.indexOf(p_gene) >= 0) {
            throw new GeneListException("It already exists Label " + p_gene.getLabel());
        }
        this.m_values.add(p_gene);
    }

    public void clear() {
        this.m_values.clear();
    }

    public int size() {
        return this.m_values.size();
    }

    public Gene getGene(String p_label) throws GeneListException {
        for (Gene g : this.m_values) {
            if (!g.getLabel().equals(p_label)) continue;
            return g;
        }
        throw new GeneListException("Error NotFound Gene Label =" + p_label);
    }

    public Gene getGene(int p_index) throws GeneListException {
        if (p_index < 0 || p_index >= this.size()) {
            throw new GeneListException("Error NotFound Gene Index =" + p_index);
        }
        return this.m_values.get(p_index);
    }

    public void print(PrintStream p_out) {
        for (Gene g : this.m_values) {
            p_out.println(g.getStatus());
        }
    }

    public String toString() {
        String returnValue = "";
        int i = 0;
        while (i < this.m_values.size()) {
            Gene g = this.m_values.get(i);
            returnValue = String.valueOf(returnValue) + (i == 0 ? "" : ",") + g.getLabel() + "=" + UtilDouble.format(g.getDoubleValue(), g.getScale());
            ++i;
        }
        return returnValue;
    }

    public String getValuesString() {
        String returnValue = "";
        int i = 0;
        while (i < this.m_values.size()) {
            Gene g = this.m_values.get(i);
            returnValue = String.valueOf(returnValue) + (i == 0 ? "" : ",") + UtilDouble.format(g.getDoubleValue(), g.getScale());
            ++i;
        }
        return returnValue;
    }

    public String getLabelsString() {
        String returnValue = "";
        int i = 0;
        while (i < this.m_values.size()) {
            Gene g = this.m_values.get(i);
            returnValue = String.valueOf(returnValue) + (i == 0 ? "" : ",") + g.getLabel();
            ++i;
        }
        return returnValue;
    }

    public void copyDesign(GeneList p_src) throws GeneListException {
        int i = 0;
        while (i < this.m_values.size()) {
            Gene me = this.getGene(i);
            me.copyDesign(p_src.getGene(i));
            ++i;
        }
    }

    public void setValue(Gene p_src) {
        for (Gene g : this.m_values) {
            if (!g.getLabel().equals(p_src.getLabel())) continue;
            g.setDoubleValue(p_src.getDoubleValue());
        }
    }

    public void setValues(GeneList p_src) {
        for (Gene g : p_src.m_values) {
            this.setValue(g);
        }
    }

    public GeneList createOptimizeGeneList() throws GeneListException {
        GeneList returnValue = new GeneList();
        for (Gene g : this.m_values) {
            if (!g.isOptimize()) continue;
            returnValue.add(g.clone());
        }
        return returnValue;
    }

    public ArrayList<Gene> getValues() {
        return this.m_values;
    }

    public void setValues(ArrayList<Gene> p_values) {
        this.m_values = p_values;
    }
}

