/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.EntryPoint;
import jp.robotbrain.signal.IndexStream;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.TypeIndexStream;

@EntryPoint
@TypeIndexStream(value="CandleStickList")
@GeneDefaultLabelList(values={"minute"})
public class CandleStickListStream
extends IndexStream {
    private static final long serialVersionUID = 1L;
    private final CandleStickList m_candleStickList = new CandleStickList();

    public CandleStickListStream(String p_label, GeneList p_geneList) throws GeneListException {
        super(p_label, CandleStickListStream.getIconName(p_geneList.getGene(0).getIntValue()));
    }

    public CandleStickListStream(String p_label, GeneList p_geneList, String p_minuteLabel) throws GeneListException {
        super(p_label, CandleStickListStream.getIconName(p_geneList.getGene(p_minuteLabel).getIntValue()));
    }

    private static NmIcon getIconName(int p_minute) {
        switch (p_minute) {
            case 10: {
                return NmIcon.CANDLESTICK10;
            }
            case 20: {
                return NmIcon.CANDLESTICK20;
            }
            case 30: {
                return NmIcon.CANDLESTICK30;
            }
            case 60: {
                return NmIcon.CANDLESTICK60;
            }
            case 90: {
                return NmIcon.CANDLESTICK90;
            }
            case 120: {
                return NmIcon.CANDLESTICK120;
            }
            case 180: {
                return NmIcon.CANDLESTICK180;
            }
            case 240: {
                return NmIcon.CANDLESTICK240;
            }
            case 1440: {
                return NmIcon.CANDLESTICK1440;
            }
        }
        return null;
    }

    public boolean enter(CandleStick p_src) throws IndexStreamException {
        if (p_src == null) {
            throw new IndexStreamException("Null Error");
        }
        this.m_candleStickList.addObject(p_src);
        return this.notifyIndexNext();
    }

    @Override
    public boolean notifyIndexSub() throws IndexStreamException {
        throw new IndexStreamException("This Stream is Only Enter");
    }

    public CandleStickList getValues() {
        return this.m_candleStickList;
    }

    public CandleStickList getViewValues() {
        return this.m_candleStickList;
    }

    @Override
    public void economizeMemory() {
        this.m_candleStickList.setCapacity(this.getDestinationMaxCost());
    }

    @Override
    public void economizeMemory(int p_capacity) {
        int capacity = Math.max(p_capacity, this.getDestinationMaxCost());
        this.m_candleStickList.setCapacity(capacity);
    }
}

