/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;

public class IndexObjectList<T extends IndexObject>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int m_capacity;
    private ArrayList<T> m_objectList;
    private NmViewType m_viewType;

    protected IndexObjectList(NmViewType p_viewType) {
        this.m_objectList = new ArrayList();
        this.m_capacity = Integer.MAX_VALUE;
        this.m_viewType = p_viewType;
    }

    private IndexObjectList(NmViewType p_viewType, List<T> p_src) {
        this.m_objectList = p_src == null ? new ArrayList() : new ArrayList<T>(p_src);
        this.m_capacity = Integer.MAX_VALUE;
        this.m_viewType = p_viewType;
    }

    protected IndexObjectList(NmViewType p_viewType, IndexObjectList<T> p_src) {
        this.m_objectList = p_src == null ? new ArrayList() : new ArrayList<T>(p_src.m_objectList);
        this.m_capacity = Integer.MAX_VALUE;
        this.m_viewType = p_viewType;
    }

    public IndexObjectList<T> clone() {
        IndexObjectList<T> returnValue = new IndexObjectList<T>(this.m_viewType, this.m_objectList);
        returnValue.m_capacity = this.m_capacity;
        return returnValue;
    }

    public final T get(int p_no) {
        if (this.size() <= 0) {
            return null;
        }
        if (this.size() <= p_no) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(p_no));
    }

    public final T get(Tag p_tag) {
        for (IndexObject o : this.m_objectList) {
            if (!o.getTag().equals(p_tag)) continue;
            return (T)o;
        }
        return null;
    }

    public final T getLast() {
        if (this.size() <= 0) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(this.m_objectList.size() - 1));
    }

    public final T getPrev(int p_count) {
        int prevIndex = this.size() - p_count - 1;
        if (prevIndex < 0) {
            return null;
        }
        if (prevIndex >= this.size()) {
            return null;
        }
        return (T)((IndexObject)this.m_objectList.get(prevIndex));
    }

    public final IndexObjectList<T> getMidList(int p_countBack, int p_countList) {
        int to;
        int from = this.size() - p_countBack;
        if (from >= (to = this.size() - (p_countList - 1))) {
            return null;
        }
        List<T> sub = this.m_objectList.subList(from, to);
        return new IndexObjectList<T>(this.m_viewType, sub);
    }

    public IndexObjectList<T> getTailList(int p_count) {
        int tailCount = p_count;
        if (this.size() < tailCount) {
            tailCount = this.size();
        }
        List<T> sub = this.m_objectList.subList(this.size() - tailCount, this.size());
        return new IndexObjectList<T>(this.m_viewType, sub);
    }

    public IndexObjectList<T> getTailList(Tag p_tag) {
        int index = -1;
        int i = 0;
        while (i < this.m_objectList.size()) {
            if (((IndexObject)this.m_objectList.get(i)).getTag().createDate().compareTo(p_tag.createDate()) >= 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return null;
        }
        List<T> sub = this.m_objectList.subList(index, this.size());
        return new IndexObjectList<T>(this.m_viewType, sub);
    }

    public final IndexObjectList<T> getTailListDay(int p_daycount) {
        if (this.size() < p_daycount) {
            return null;
        }
        String date = "";
        int dayCount = 0;
        IndexObjectList<IndexObject> returnValue = new IndexObjectList<IndexObject>(this.m_viewType);
        int i = this.m_objectList.size() - 1;
        while (i >= 0) {
            IndexObject object = (IndexObject)this.m_objectList.get(i);
            if (!object.getTag().getDate().equals(date)) {
                ++dayCount;
                date = object.getTag().getDate();
            }
            if (dayCount > p_daycount) break;
            returnValue.add(0, object);
            --i;
        }
        return returnValue;
    }

    public void remove(String p_date) {
        ArrayList<IndexObject> newList = new ArrayList<IndexObject>();
        int i = 0;
        while (i < this.m_objectList.size()) {
            IndexObject obj = (IndexObject)this.m_objectList.get(i);
            if (obj.getTag().getDate().equals(p_date)) {
                this.m_objectList.set(i, null);
            } else {
                newList.add(obj);
            }
            ++i;
        }
        this.m_objectList = newList;
    }

    protected final ArrayList<T> getObjectList() {
        return new ArrayList<T>(this.m_objectList);
    }

    protected void add(T p_src) {
        if (p_src == null) {
            return;
        }
        if (this.size() >= this.m_capacity) {
            this.m_objectList.remove(0);
        }
        this.m_objectList.add(p_src);
    }

    protected void add(int p_index, T p_src) {
        if (p_src == null) {
            return;
        }
        if (this.size() >= this.m_capacity) {
            return;
        }
        this.m_objectList.add(p_index, p_src);
    }

    public final boolean isExist() {
        if (this.size() <= 0) {
            return false;
        }
        T p = this.m_objectList.get(0);
        return p != null;
    }

    public final int size() {
        return this.m_objectList.size();
    }

    public final void print(PrintStream p_out) {
        if (this.size() <= 0) {
            return;
        }
        ((IndexObject)this.getLast()).printHeader(p_out);
        for (IndexObject o : this.m_objectList) {
            o.print(p_out);
        }
    }

    public final void print(PrintStream p_out, String p_date) {
        if (this.size() <= 0) {
            return;
        }
        ((IndexObject)this.getLast()).printHeader(p_out);
        for (IndexObject o : this.m_objectList) {
            if (!o.getTag().getDate().equals(p_date)) continue;
            o.print(p_out);
        }
    }

    public final String toXml() {
        if (this.size() <= 0) {
            return "";
        }
        StringBuilder returnValue = new StringBuilder();
        for (IndexObject o : this.m_objectList) {
            returnValue.append(o.toXml());
        }
        return returnValue.toString();
    }

    public int getCapacity() {
        return this.m_capacity;
    }

    public void setCapacity(int p_capacity) {
        this.m_capacity = p_capacity <= 0 ? 1 : p_capacity;
        IndexObjectList<T> tail = this.getTailList(this.m_capacity);
        this.m_objectList = tail == null ? new ArrayList() : tail.m_objectList;
    }

    public int indexOf(IndexObject p_src) {
        return this.m_objectList.indexOf(p_src);
    }

    public NmViewType getViewType() {
        return this.m_viewType;
    }

    public void setViewType(NmViewType p_viewType) {
        this.m_viewType = p_viewType;
    }

    public void clear() {
        this.m_objectList.clear();
    }
}

