/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.EnabledDefaultSignal;
import jp.robotbrain.signal.EnabledOutputSignal;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.IndexStreamException;
import jp.robotbrain.signal.IndexStreamPort;
import jp.robotbrain.signal.InputComponentList;
import jp.robotbrain.signal.JudgmentResult;
import jp.robotbrain.signal.NmIcon;
import jp.robotbrain.signal.NmSignal;
import jp.robotbrain.signal.SignalStream;
import jp.robotbrain.signal.TypeSignalStream;

@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@InputComponentList(values={"baseLine@IndexLine", "*upperRange@IndexLine", "*lowerRange@IndexLine", "moveLine@IndexLine"})
public class InnerRangeSignal
extends SignalStream {
    private static final long serialVersionUID = 1L;

    public InnerRangeSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
        super(p_label, NmIcon.INNERRANGE, p_priority, p_outputSignal);
        this.getPortList().add("baseLine@IndexLine", 1);
        this.getPortList().add("*upperRange@IndexLine", 1);
        this.getPortList().add("*lowerRange@IndexLine", 1);
        this.getPortList().add("moveLine@IndexLine", 1);
    }

    @Override
    protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
        double moveValue;
        IndexStreamPort base = this.getPortList().get("baseLine@IndexLine");
        IndexStreamPort upper = this.getPortList().get("*upperRange@IndexLine");
        IndexStreamPort lower = this.getPortList().get("*lowerRange@IndexLine");
        IndexStreamPort move = this.getPortList().get("moveLine@IndexLine");
        if (base == null) {
            throw new IndexStreamException("baseLine@IndexLine Port Null Error");
        }
        if (upper == null) {
            throw new IndexStreamException("*upperRange@IndexLine Port Null Error");
        }
        if (lower == null) {
            throw new IndexStreamException("*lowerRange@IndexLine Port Null Error");
        }
        if (move == null) {
            throw new IndexStreamException("moveLine@IndexLine Port Null Error");
        }
        if (base.getIndexStream() == null) {
            return null;
        }
        if (move.getIndexStream() == null) {
            return null;
        }
        if (base.getIndexStream().getValues() == null) {
            return null;
        }
        if (move.getIndexStream().getValues() == null) {
            return null;
        }
        if (!(base.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("baseLine@IndexLine Instance Error");
        }
        if (!(move.getIndexStream().getValues() instanceof IndexLine)) {
            throw new IndexStreamException("moveLine@IndexLine Instance Error");
        }
        IndexLine baseLine = (IndexLine)base.getIndexStream().getValues();
        if (baseLine.size() < 1) {
            return null;
        }
        IndexLine moveLine = (IndexLine)move.getIndexStream().getValues();
        if (moveLine.size() < 1) {
            return null;
        }
        IndexLine upperLine = null;
        if (upper.getIndexStream() != null && upper.getIndexStream().getValues() != null) {
            if (!(upper.getIndexStream().getValues() instanceof IndexLine)) {
                throw new IndexStreamException("*upperRange@IndexLine Instance Error");
            }
            upperLine = (IndexLine)upper.getIndexStream().getValues();
            if (upperLine.size() < 1) {
                return null;
            }
        }
        IndexLine lowerLine = null;
        if (lower.getIndexStream() != null && lower.getIndexStream().getValues() != null) {
            if (!(lower.getIndexStream().getValues() instanceof IndexLine)) {
                throw new IndexStreamException("*lowerRange@IndexLine Instance Error");
            }
            lowerLine = (IndexLine)lower.getIndexStream().getValues();
            if (lowerLine.size() < 1) {
                return null;
            }
        }
        NmSignal returnValue = NmSignal.NOSIGNAL;
        double baseValue = ((IndexPoint)baseLine.getLast()).getValue();
        double upperValue = 0.0;
        if (upperLine != null) {
            upperValue = ((IndexPoint)upperLine.getLast()).getValue();
        }
        double lowerValue = 0.0;
        if (lowerLine != null) {
            lowerValue = ((IndexPoint)lowerLine.getLast()).getValue();
        }
        returnValue = (moveValue = ((IndexPoint)moveLine.getLast()).getValue()) <= baseValue + upperValue && moveValue >= baseValue - lowerValue ? this.getOutputSignal() : this.getDefaultSignal();
        return new JudgmentResult(((IndexPoint)moveLine.getLast()).getTag(), returnValue);
    }
}

