<?php

/*
 +-----------------------------------------------------------------------+
 | program/localization/index.inc                                        |
 |                                                                       |
 | This file is part of the RoundCube Webmail client                     |
 | Copyright (C) 2005, RoundCube Dev, - Switzerland                      |
 | Licensed under the GNU GPL                                            |
 |                                                                       |
 | PURPOSE:                                                              |
 |   Provide centralized location for keeping track of                   |
 |   available languages                                                 |
 |                                                                       |
 +-----------------------------------------------------------------------+
 | Author: Thomas Bruederli <roundcube@gmail.com>                        |
 +-----------------------------------------------------------------------+

 $Id: index.inc,v 1.16 2006/02/04 18:05:36 roundcube Exp $
 
 */
 
 $rcube_languages = array(
	'en_US' => 'English (US)',
	'en_GB' => 'English (GB)',
	'ar'    => 'Arabic',
	'bg'    => 'Bulgarian',
	'bs_BA' => 'Bosnian (Bosanski)',
	'tw'    => 'Chinese (BIG5)',
	'cn'    => 'Chinese (GB2312)',
	'cz'    => 'Czech',
 	'ca'    => 'Català',
	'da'    => 'Dansk',
 	'de_DE' => 'Deutsch',
 	'es'    => 'Español',
 	'ee'    => 'Estonian',
	'eu'    => 'Euskara',
	'fr'    => 'Français', 
	'ga'    => 'Galician',
	'el'    => 'Greek',
	'hr'	=> 'Hrvatski',
	'hu'    => 'Hungarian',
	'it'    => 'Italiano',
	'ja'    => 'Japanese (日本語)',
	'kr'    => 'Korean',
	'lv'    => 'Latvian',
	'nl_NL' => 'Nederlands',
	'nl_BE' => 'Flemish',
	'nb_NO' => 'Norsk (bokmål)',
	'nn_NO' => 'Norsk (nynorsk)',
	'fa'    => 'Persian',
	'pl'    => 'Polski',
	'pt_PT' => 'Portuguese (Standard)',
	'pt_BR' => 'Portuguese (Brazilian)',
	'ro'    => 'Romanian',
	'ru'    => 'Russian',
	'fi'    => 'Suomi',
	'se'    => 'Svenska',
	'si'    => 'Slovenian',
	'sk'    => 'Slovak',
	'tr'    => 'Turkish',
	'vn'    => 'Vietnamese'
);

$rcube_language_aliases = array(
	'bs' => 'bs_BA',
	'de' => 'de_DE',
	'en' => 'en_US',
	'ja' => 'ja_JP',
	'nl' => 'nl_NL',
	'no' => 'nn_NO',
	'pt' => 'pt_PT'
);

$rcube_charsets = array();
$MBSTRING_LOADED = extension_loaded( "mbstring");
if ($MBSTRING_LOADED) {
  $MBSTRING = TRUE;
  if (function_exists("mb_mbstring_encodings"))
    $MBSTRING_ENCODING = mb_mbstring_encodings();
  else
    $MBSTRING_ENCODING = array( "ISO-8859-1", "UTF-7", "UTF7-IMAP", "UTF-8", "ISO-2022-JP", "EUC-JP", "EUCJP-WIN", "SJIS", "SJIS-WIN");

  $MBSTRING_ENCODING = array_map( "strtoupper", $MBSTRING_ENCODING);
  if (in_array( "SJIS", $MBSTRING_ENCODING))
    $MBSTRING_ENCODING[] = "SHIFT_JIS";
} else {
  $MBSTRING = FALSE;
  $MBSTRING_ENCODING = array();
}

?>
