class GlossaryController < ApplicationController
  unloadable

  layout 'base'  
  before_filter :find_project, :authorize
  before_filter :find_term, :only => [:show, :edit, :destroy]

  helper :attachments
  include AttachmentsHelper
  helper :sort
  include SortHelper
  helper :glossary
  include GlossaryHelper

  def index_base
    @is_index = true
    query_str = "project_id = #{@project.id} and category_id is %s null"
    @categorized_terms = Term.find(:all,
                                   :conditions => [sprintf(query_str, "not"), true])
    @not_categorized_terms = Term.find(:all,
                                       :conditions => [sprintf(query_str, ""), true],
                                       :order => "name")

    unless (request.get? || request.xhr?)

    end

    respond_to do |format|
      format.html { render :template => 'glossary/index.html.erb', :layout => !request.xhr? }
      format.csv  { send_data(glossary_to_csv(Term.find(:all,
                                                        :conditions =>
                                                        "project_id = #{@project.id}")),
                              :type => 'text',
                              :filename => "glossary-export.csv") }
    end
  end
  
  def index
    @counter_view_action = 'show_all'
    index_base()
  end


  def show_all
    @counter_view_action = 'index'
    index_base()
  end


  def show
    #Term.update_all("id = #{@term.id}")
    @term_categories = TermCategory.find(:all, :conditions => "project_id = #{@project.id}", :order => "position")
    respond_to do |format|
      format.html { render :template => 'glossary/show.html.erb', :layout => !request.xhr? }
    end
  end

  def new
    @term_categories = TermCategory.find(:all, :conditions => "project_id = #{@project.id}", :order => "position")
    @term = Term.new(params[:term])
    @term.project_id = @project.id

    unless (request.get? || request.xhr?)
      @term.author_id = User.current.id
      @term.updater_id = User.current.id
      if @term.save
        attach_files(@term, params[:attachments])
        flash[:notice] = l(:notice_successful_create)
        if (params[:continue])
          redirect_to :controller => 'glossary', :action => 'new', :id => @project
        else
          redirect_to :controller => 'glossary', :action => 'show', :id => @project,
                  :term_id => @term
        end
      end		
    end
  end

  def preview
    @text = params[:term][:description]
    render :partial => 'common/preview'
  end

  def edit
    @term_categories = TermCategory.find(:all, :conditions => "project_id = #{@project.id}", :order => "position")
    
    if request.post?
      @term.attributes = params[:term]
      @term.updater_id = User.current.id
      if @term.save
        attach_files(@term, params[:attachments])
        flash[:notice] = l(:notice_successful_update)
        redirect_to :controller => 'glossary', :action => 'show', :id => @project, :term_id => @term
        return
      end
    end
  rescue ActiveRecord::StaleObjectError
    # Optimistic locking exception
    flash.now[:error] = l(:notice_locking_conflict)
  end

  def destroy
    @term.destroy
    redirect_to :action => 'index', :id => @project
  end

  def add_term_category
    @category = TermCategory.new(params[:category])
    @category.project_id = @project.id
    if request.post? and @category.save
      respond_to do |format|
        format.html do
          flash[:notice] = l(:notice_successful_create)
          redirect_to :controller => 'term_categories', :action => 'index', :id => @project
        end
        format.js do
          term_categories = TermCategory.find(:all, :conditions => "project_id = #{@project.id}")
          render(:update) {|page| page.replace "term_category_id",
            content_tag('select', '<option></option>' + options_from_collection_for_select(term_categories, 'id', 'name', @category.id), :id => 'term_category_id', :name => 'term[category_id]')
          }
        end
      end
    end
  end

  private

  def find_project   
    @project = Project.find(params[:id])
  rescue ActiveRecord::RecordNotFoundpp
    render_404
  end
  
  def find_term
    @term = Term.find(:first,
                      :conditions => "project_id = #{@project.id} and id = #{params[:term_id]}")
    render_404 unless @term
  rescue
    render_404
  end

  def attach_files(val, prm)
    Attachment.attach_files(val, prm)
  end

end
