/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.ArithmeticRightShiftCommand;
import jp.sourceforge.expression_computer.command.LeftShiftCommand;
import jp.sourceforge.expression_computer.command.LogicalRightShiftCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;

public final class ShiftExpressionNode
extends AbstractNode
implements OperandNode {
    private Node[] nodes;

    public ShiftExpressionNode(Node[] nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes\u304cnull\u3067\u3059\u3002");
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) {
                throw new NullPointerException("nodes[" + i + "]\u304cnull\u3067\u3059\u3002");
            }
            if (i % 2 == 0 && !(nodes[i] instanceof OperandNode)) {
                throw new IllegalArgumentException("nodes[" + i + "]\u304c\u9805\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            if (i % 2 != 1 || nodes[i] instanceof OperatorNode) continue;
            throw new IllegalArgumentException("nodes[" + i + "]\u304c\u6f14\u7b97\u5b50\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (nodes.length < 3) {
            throw new IllegalArgumentException("nodes.length < 3\u3067\u3059\u3002");
        }
        if (nodes.length % 2 != 1) {
            throw new IllegalArgumentException("nodes.length\u304c\u5947\u6570\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.nodes = (Node[])nodes.clone();
    }

    public void compile(CompileContext context) {
        this.nodes[0].compile(context);
        for (int i = 2; i < this.nodes.length; i += 2) {
            this.nodes[i].compile(context);
            this.nodes[i - 1].compile(context);
        }
    }

    public Node[] getChildren() {
        return (Node[])this.nodes.clone();
    }

    public String toString() {
        return this.getClass().getName() + this.toChildrenString();
    }

    public static final class LogicalRightShiftNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            context.add(new LogicalRightShiftCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class ArithmeticRightShiftNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            context.add(new ArithmeticRightShiftCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class LeftShiftNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            context.add(new LeftShiftCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static abstract class OperatorNode
    extends AbstractNode {
        public final Node[] getChildren() {
            return new Node[0];
        }
    }
}

