/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import jp.sourceforge.expression_computer.ComputeException;
import jp.sourceforge.expression_computer.Function;

public final class ComputeContext {
    private Map variableMap = new HashMap();
    private Map functionMap = new HashMap();
    private Stack stack = new Stack();

    public int sizeStack() {
        return this.stack.size();
    }

    public double popStack() {
        if (this.stack.empty()) {
            throw new ComputeException("\u30b9\u30bf\u30c3\u30af\u304c\u7a7a\u3067\u3059\u3002");
        }
        return (Double)this.stack.pop();
    }

    public double peekStack() {
        if (this.stack.empty()) {
            throw new ComputeException("\u30b9\u30bf\u30c3\u30af\u304c\u7a7a\u3067\u3059\u3002");
        }
        return (Double)this.stack.peek();
    }

    public void pushStack(double value) {
        this.stack.push(new Double(value));
    }

    public void setVariable(String name, double value) {
        if (name == null) {
            throw new NullPointerException("name\u304cnull\u3067\u3059\u3002");
        }
        this.variableMap.put(name, new Double(value));
    }

    public double getVariable(String name) {
        if (!this.variableMap.containsKey(name)) {
            throw new ComputeException("\u5909\u6570{" + name + "}\u306f\u5ba3\u8a00\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        double value = (Double)this.variableMap.get(name);
        return value;
    }

    public String[] getVariableNames() {
        String[] variableNames = this.variableMap.keySet().toArray(new String[0]);
        return variableNames;
    }

    public void addFunction(String name, Function func) {
        if (name == null) {
            throw new NullPointerException("name\u304cnull\u3067\u3059\u3002");
        }
        if (func == null) {
            throw new NullPointerException("func\u304cnull\u3067\u3059\u3002");
        }
        this.functionMap.put(name, func);
    }

    public Function getFunction(String name) {
        if (!this.functionMap.containsKey(name)) {
            throw new ComputeException("\u95a2\u6570{" + name + "}\u306f\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Function func = (Function)this.functionMap.get(name);
        return func;
    }
}

