/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.ConditionCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;

public final class ConditionalExpressionNode
extends AbstractNode
implements OperandNode {
    private OperandNode operand1;
    private QuestionNode question;
    private OperandNode operand2;
    private ColonNode colon;
    private OperandNode operand3;

    public ConditionalExpressionNode(OperandNode operand1, OperandNode operand2, OperandNode operand3) {
        if (operand1 == null) {
            throw new NullPointerException("operand1\u304cnull\u3067\u3059\u3002");
        }
        if (operand2 == null) {
            throw new NullPointerException("operand2\u304cnull\u3067\u3059\u3002");
        }
        if (operand3 == null) {
            throw new NullPointerException("operand3\u304cnull\u3067\u3059\u3002");
        }
        this.operand1 = operand1;
        this.question = new QuestionNode();
        this.operand2 = operand2;
        this.colon = new ColonNode();
        this.operand3 = operand3;
    }

    public void compile(CompileContext context) {
        this.operand1.compile(context);
        if (this.question != null) {
            this.operand2.compile(context);
            this.operand3.compile(context);
            context.add(new ConditionCommand());
        }
    }

    public Node[] getChildren() {
        return new Node[]{this.operand1, this.question, this.operand2, this.colon, this.operand3};
    }

    public String toString() {
        return this.getClass().getName() + this.toChildrenString();
    }

    public static final class ColonNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class QuestionNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static abstract class OperatorNode
    extends AbstractNode {
        public final Node[] getChildren() {
            return new Node[0];
        }
    }
}

