#### test/ebdic-koujien.rb -- unit test for ebdic module, using KOUJIEN

require 'test/ebdic-common'

class TestEBDicKoujien <TestEBDicCommon
  def setup
    super("/opt/epwing/koujien")
  end

  def test_search_not_found
    check([""], search("ۤ"))
    check([""], search("\001\001"))
    check([""], search(""))
  end

  def test_search
    check(["ȥޥ", ""], search("Ȥޤ"))
    check(["", ""], search(""))
    check(["", "oui", "ե"], search(""))
    check(["ų̥ȥ󥸥"], search("Ǥ󤫤Ȥ󤸤"))
    check(["Żҥԥ"], search("Ǥ󤷤Ԥ󤭤礦ᤤ"))
    check(["Żҥ᡼"], search("Ǥ󤷤᡼"))
    check(["פΰҤڤ"], search("ȤΤ򤫤뤭Ĥ"))
    check(["Ρ٥"], search("Ρ٤뤷礦"))
    check(["Ǥ", "", "", "", "", "", "", "", "ޥ", "maquis", "ե"],
	  search("ޤ"))
    check(["United States of America"],
	  search("ʤƤäɤơĤ֤꤫"))
    check(["衼å", "Europa", "ݥȥ", "", ""],
	  search("衼ä"))
    check(["亮ȥ", "Washington", "亮ȥ", "Washington", ""],
	  search("路Ȥ"))
    check(["", "ۤ"], search("Ϥ"))
  end

  def test_wildcard_not_found
    check([""], search("*"))
  end

  def test_wildcard
    check(["", "θ", "פΰҤڤ"], search("*Ĥ"))
    check(["Ϥͧ"], search("Ф*"))
  end
end

if __FILE__ == $0
  require 'test/unit/ui/console/testrunner'
  Test::Unit::UI::Console::TestRunner.run(TestEBDicKoujien.suite)
end

# test/ebdic-koujien.rb ends here
