### skkserv/bdbdic.rb --- rskkserv module for Berkeley DB dictionary.

## Copyright (C) 2003  YAMASHITA Junji

## Author:	YAMASHITA Junji <ysjj@unixuser.org>
## Version:	1.0

## This file is part of rskkserv.

## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License as
## published by the Free Software Foundation; either version 2, or (at
## your option) any later version.

## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.

### Code:

require "skkserv/logger"

begin
  require "bdb"
rescue LoadError
  Logger::log(Logger::INFO, "failed to load bdb")
end

class BDBDic
  def initialize(path, skk)
    Logger::log(Logger::DEBUG, "BDBDic: path %s", path)

    @skk = File.open(skk)
    @bdb = BDB::Btree.open(path)
  end

  def search(kana)
    idx = @bdb[kana]

    return [] if idx.nil?

    @skk.seek(idx.to_i, 0)
    buf = @skk.readline

    return buf[(kana.length+1)..-3].split("/")
  end

  def self.create(path, options, config)
    return BDBDic.new(path, options["skk"])
  end
end

if __FILE__ == $0
  print BDBDic.new("test/SKK-JISYO.L.db").search("").join("/"), "\n"
end
