#!/usr/bin/env perl -w

#
# rss2imap_config - rss2imap logger module.
#
# Copyright (C) 2005 Yoshinari Takaoka <mumumu@mumumu.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of the
# GPL2, GNU General Public License version 2.
#
# $Id: Logger.pm,v 1.3 2005/10/07 11:41:25 mumumu-org Exp $
#

use strict;
use RSS2IMAPLIB::Config;

package RSS2IMAPLIB::Logger;
{

    our $log_dir = "log/";
    our $log_filename = $log_dir."rss2imap.log";

    sub new {

        my $pkg_name = shift;
        if( ! -e ($log_dir) ) {
            mkdir $log_dir or die "could not create log directory.";
        }

        open LOG_FH, ">>$log_filename" or die "could not open log file.";
        my $log_ref = *LOG_FH{IO};
        bless { log => $log_ref }, $pkg_name;
    }


    sub log {

        my $this = shift;
        my @messages = @_;

        print { $this->{'log'} } (@messages);
    }

}
