////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
//@file  rtc_control.cpp
//@brief RTC制御関数．
//$Date$ 2009/12/5
//@author eno 
//@mail:enoreplies@gmail.com
//@WebPage:http://www15.atpages.jp/~technotes/wiki/
//$Id$ 
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/*
rtc-controller

The MIT License

Copyright (c) 2009 eno<enoreplies@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


#include "rtc_control.h"
#define COMPMAXNUM 100

void name_show(string namelist[],int namelist_num){
	if(namelist_num==0) return;
	cout<<endl<<endl;
	for(int i=0;i<namelist_num;i++){
		//if(i%2==0)
		cout<<i<<":"<<namelist[i]<<endl;
	}
	cout<<endl<<endl;
}

int name_to_number(string namelist[],int namelist_num,string name,int &num){

	int same_check=0;
	int num_buff=-1;
	for(int i=0;i<namelist_num;i++){
		if(namelist[i]==name){
			same_check++;
			num_buff=i;
		}
	}

	if(same_check==0){		
		cout<<"Error:this name is not:"<<name<<endl;
		return SIGNAL_ERROR;
	}
	if(same_check>1){	
		cout<<"Error:this name is other:"<<name<<endl;
		return SIGNAL_ERROR;
	}
	num=num_buff;
	return SIGNAL_TRUE;
}

int port_number_to_name(string namelist[],int namelist_num,int num,string &name){
	if(num<namelist_num) {
		name=namelist[num];
		return SIGNAL_TRUE;
	}
	else{
		cout<<"Error:this number port is not"<<endl;
		name="error";
	}
	return SIGNAL_ERROR;
}


int rtc_number_to_name(string namelist[],int namelist_num,int num,string &name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	if(num<namelist_num) {
#else								//This Code for OpenRTM-1.0
	if((num<namelist_num)&&(num>0)) {	//namelist[0]->manegar

#endif
		name=namelist[num];
		return SIGNAL_TRUE;
	}
	else{
		cout<<"Error:this number comp is not"<<endl;
		name="error";
	}
	return SIGNAL_ERROR;
}

int str_conv_int(string str){
	const char *chr = str.c_str();
	int num_check=0;
	int i=0;
	while(chr[i] != NULL){
		if(isdigit(chr[i++])!=0){
			num_check++;
		}
	}
	if(num_check==(signed)str.size()) {
		return atoi(str.c_str());
	}
	else{
		return SIGNAL_ERROR;
	}
}

vector<string> splitstr(string str, string delim) {
	vector<string> items;
	size_t dlm_idx;
	if(str.npos == (dlm_idx = str.find_first_of(delim))) {
		items.push_back(str.substr(0, dlm_idx));
	}
	while(str.npos != (dlm_idx = str.find_first_of(delim))) {
		if(str.npos == str.find_first_not_of(delim)) {
			break;
		}
		items.push_back(str.substr(0, dlm_idx));
		dlm_idx++;
		str = str.erase(0, dlm_idx);
		if(str.npos == str.find_first_of(delim) && "" != str) {
			items.push_back(str);
			break;
		}
	}
	return items;
}

void ListRecursive(CosNaming::NamingContext_ptr context,vector<string> &rtclist,string &name){
	CosNaming::BindingList_var     bl;
	CosNaming::BindingIterator_var bi;
	CORBA::Boolean cont(true);
	int m_blLength=COMPMAXNUM;
	context->list(m_blLength, bl, bi);

	while (cont){
		CORBA::ULong len(bl->length());
		for (CORBA::ULong i = 0; i < len; ++i){

			if (bl[i].binding_type == CosNaming::ncontext){
				CosNaming::NamingContext_var next_context;
				next_context = CosNaming::NamingContext::_narrow(context->resolve(bl[i].binding_name));
				string namebuff=name;
				name+=bl[i].binding_name[0].id;
				name+="/";
				ListRecursive(next_context,rtclist,name); 
				name=namebuff;
			}
			else if (bl[i].binding_type == CosNaming::nobject){
				if((signed)rtclist.size()>m_blLength)
					break;
				string name_buff=name;
				name_buff+=bl[i].binding_name[0].id;
				rtclist.push_back(name_buff);
			}
			else {
			}
		}
		if (CORBA::is_nil(bi)) {
			cont = 0;
		}
		else {
			bi->next_n(m_blLength, bl);
		}
	}
	return;
}

////ポートの接続状態・接続先の一覧を出す．
int rtc_get_rtclist(RTC::CorbaNaming &naming,vector<string> &rtclist){

	//ネーミングサーバに問い合わせ名前一覧を出す
	CosNaming::NamingContext_ptr name_cxt = naming.getRootContext();
	rtclist.clear();
	string name;
	ListRecursive(name_cxt,rtclist,name);
	return SIGNAL_TRUE;
}





//RTCompのポート番号を指定し，特定のコネクタのみの，ポートの接続を解除．
int rtc_disconnect(RTC::CorbaNaming &naming,string rtc_name,int port_num,string connect_id){
#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var plist;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var plist;
#endif
	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());

	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	plist = rtc0->get_ports();

	plist[(CORBA::ULong)port_num]->disconnect(connect_id.c_str());
	//assert(plist->length() > 0);
	return SIGNAL_TRUE;
}


//RTCompのポート番号を指定し，全てのコネクタの，ポートの接続を解除．
int rtc_disconnect(RTC::CorbaNaming &naming,string rtc_name,int port_num){
#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var plist;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var plist;
#endif
	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());

	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	plist = rtc0->get_ports();

	plist[(CORBA::ULong)port_num]->disconnect_all();
	//assert(plist->length() > 0);
	return SIGNAL_TRUE;
}

//RTコンポーネントのポートの接続を全て解除．
int rtc_disconnect(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var plist;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var plist;
#endif
	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	// get ports
	plist = rtc0->get_ports();
	for (CORBA::ULong i(0), n(plist->length()); i < n; ++i){
		plist[(CORBA::ULong)i]->disconnect_all();
	}
	//assert(plist->length() > 0);

	return SIGNAL_TRUE;
}


//ネームサーバのRTコンポーネントを再帰的にdestroyする
int rtc_destoryall(RTC::CorbaNaming &naming){
	naming.destroyRecursive(naming.getRootContext());
	return SIGNAL_TRUE;
}


//ネームサーバ・RTコンポーネント・ポート番号を指定することで，コネクションを確立．
int rtc_connect(RTC::CorbaNaming &in_naming,string pout_name,
				int pout_num,RTC::CorbaNaming &out_naming,string pin_name,int pin_num,string subs_type,string period){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
					RTC::PortList_var pin;
					RTC::PortList_var pout;
#else								//This Code for OpenRTM-1.0
					RTC::PortServiceList_var pin;
					RTC::PortServiceList_var pout;
#endif

					string DataOutRTC_NAME=pout_name+".rtc";
					string DataInRTC_NAME=pin_name+".rtc";

					RTC::CorbaConsumer<RTC::RTObject> conin, conout;

					conin.setObject(in_naming.resolve(DataInRTC_NAME.c_str()));
					pin = conin->get_ports();
					//assert(pin->length() > 0);

					conout.setObject(out_naming.resolve(DataOutRTC_NAME.c_str()));
					pout = conout->get_ports();
					//assert(pout->length() > 0);


					//Portの種類チェック
					string PortType[2];
					PortType[0] = NVUtil::toString(pin[(CORBA::ULong)pin_num]->get_port_profile()->properties,"port.port_type") ;
					PortType[1] = NVUtil::toString(pout[(CORBA::ULong)pout_num]->get_port_profile()->properties,"port.port_type") ;

					if((PortType[0]=="DataOutPort")&&(PortType[1]=="DataOutPort")){
						cout<<"Error: Same DataOutPort"<<endl ;
						return SIGNAL_ERROR;
					}
					if((PortType[0]=="DataInPort")&&(PortType[1]=="DataInPort")){
						cout<<"Error: Same DataInPort"<<endl ;
						return SIGNAL_ERROR;
					}

					////////////////////////////

					string ConnectName="_"+pout_name+"_"+pin_name;
					string ConnectIDName="_id_"+pout_name+"_"+pin_name;

					// connect ports
					RTC::ConnectorProfile prof;
					prof.connector_id = ConnectIDName.c_str();
					prof.name = CORBA::string_dup(ConnectName.c_str());
					prof.ports.length(2);
					prof.ports[0] = pin[(CORBA::ULong)pin_num];
					prof.ports[1] = pout[(CORBA::ULong)pout_num];

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
					CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.interface_type", "CORBA_Any"));
					CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.dataflow_type","Push"));
					if(subs_type=="flush")
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","Flush"));
					else if(subs_type=="new")
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","New"));
					else if(subs_type=="periodic"){
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","Periodic"));
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.push_interval",period.c_str()));
					}
#else								//This Code for OpenRTM-1.0
					CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.interface_type", "corba_cdr"));
					CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.dataflow_type","push"));
					if(subs_type=="flush")
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","flush"));
					else if(subs_type=="new")
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","new"));
					else if(subs_type=="periodic"){
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.subscription_type","periodic"));
						CORBA_SeqUtil::push_back(prof.properties,NVUtil::newNV("dataport.push_rate",period.c_str()));
					}
#endif

					RTC::ReturnCode_t ret;
					ret = pin[pin_num]->connect(prof);
					//assert(ret == RTC::RTC_OK);
					//std::cout << "Connector ID: " << prof.connector_id << std::endl;
					//    NVUtil::dump(prof.properties);
					return SIGNAL_TRUE;
}

//同じにてネームサーバ・RTコンポーネント・ポート番号を指定することで，コネクションを確立．
int rtc_connect(RTC::CorbaNaming &naming,string pout_name,int pout_num,string pin_name,int pin_num){
	rtc_connect(naming,pout_name,pout_num,naming,pin_name,pin_num,"flush","");
	return SIGNAL_TRUE;
}



//ポート名からポート番号を問い合わせる
int rtc_portname_resolution(RTC::CorbaNaming &naming,string rtc_name,string port_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::Port_ptr port;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortService_ptr port;
#endif

	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();
	int pnum=-1;

	for (CORBA::ULong i(0), n(portlist->length()); i < n; ++i){
		port = portlist[i];
		string pname;
		pname=port->get_port_profile()->name;
		cout<<port_name<<" "<<pname<<endl;
		if(port_name==pname){
			if(pnum>-1)			cout<<"Same name port Error"<<endl;

			pnum=i;
		}
	}

	return pnum;
}



//compの情報を出す．
int rtc_comp_info(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif	

	string RTC_NAME=rtc_name+".rtc";

	CORBA::Object_var obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc = RTC::RTObject::_narrow(obj);

	RTC::ComponentProfile* compProf;
	compProf = rtc->get_component_profile();
	NVUtil::dump(compProf->properties);


	cout<<"INSTANCE_NAME:"<<compProf->instance_name<<endl;
	cout<<"TYPE_NAME:"<<compProf->type_name<<endl;
	cout<<"DESCRIPTION:"<<compProf->description<<endl;
	cout<<"VERSION:"<<compProf->version<<endl;
	cout<<"VENDOR:"<<compProf->vendor<<endl;
	cout<<"CATEGORY:"<<compProf->category<<endl;


	return SIGNAL_TRUE;
}

//ポートの情報を出す．
int rtc_port_info(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif

	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();

	for (CORBA::ULong i(0); i < portlist->length(); i++)  {
		RTC::PortProfile_var pprofile;
		pprofile = portlist[i]->get_port_profile();
		RTC::ConnectorProfileList connector(pprofile->connector_profiles);
		cout<<"Port Name:"<<portlist[i]->get_port_profile()->name<<endl;
		NVUtil::dump(pprofile->properties);
		cout<<endl;
	}

	return SIGNAL_TRUE;
}

int rtc_connect_info(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif

	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();

	for (CORBA::ULong i(0); i < portlist->length(); i++)  {

		RTC::PortProfile_var pprofile;
		pprofile = portlist[i]->get_port_profile();
		RTC::ConnectorProfileList connector(pprofile->connector_profiles);
		cout<<"Port Name:"<<portlist[i]->get_port_profile()->name<<endl;
		for (CORBA::ULong j(0); j < connector.length(); ++j){

			NVUtil::dump(connector[j].properties);
			cout<<endl<<endl;
		}
	}

	return SIGNAL_TRUE;
}


//ポートの接続状態・接続先の一覧を出す．
int rtc_portshow(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif

	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();
	//	cout<<"RTC_NAME:"<<rtc_name<<endl;

	for (CORBA::ULong i(0); i < portlist->length(); i++)  {
		RTC::PortProfile_var pprofile;
		pprofile = portlist[i]->get_port_profile();
		RTC::ConnectorProfileList connector(pprofile->connector_profiles);

		//	string porttype=NVUtil::toString(pprofile->properties,"port.port_type");
		string porttype=NVUtil::toString(pprofile->properties,"dataport.data_type");


		if(connector.length()>0)
			std::cout <<"  "<<"("<<porttype<<")"<<pprofile->name<<"  "<< "Sum Connection: " << connector.length() << std::endl;
		else
			std::cout<<"  "<<"("<<porttype<<")"<<pprofile->name<<"  "<< "No Connection: " << std::endl;


		for (CORBA::ULong j(0); j < connector.length(); ++j){
			pl = connector[j].ports;
			for (CORBA::ULong k(0); k < pl.length(); ++k) {
				std::cout <<"\t"; 
				RTC::PortProfile_var pp;
				pp = pl[k]->get_port_profile();
				RTC::ComponentProfile_var rtconnector;
				rtconnector = pp->owner->get_component_profile();

				if(k!=0)cout<<"--->";
				std::cout << "  " << rtconnector->instance_name;
				std::cout << ":" << pp->name ;
			}
			cout<<endl;

		}
	}

	return SIGNAL_TRUE;
}



//特定のRTコンポーネントの状態確認．
int rtc_state(RTC::CorbaNaming &naming,string rtc_name){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif
	RTC::LifeCycleState state=eclisti[(CORBA::ULong)0]->get_component_state(rtc0);
	//RTC::LifeCycleState state=eclisti[(CORBA::ULong)0]->get_component_state(RTC::RTObject::_duplicate(rtc0._ptr()));
	cout<<rtc_name<<"\t";

	switch(state) {
				case RTC::ERROR_STATE:
					std::cout << "error" << std::endl;
					break;
				case RTC::INACTIVE_STATE:
					std::cout << "deactive" << std::endl;
					break;
				case RTC::ACTIVE_STATE:
					std::cout << "active" << std::endl;
					break;
				default:
					std::cout << "unknown" << std::endl;

	}
	return SIGNAL_TRUE;
}


//特定のRTコンポーネントをアクティブ化する
int rtc_active(RTC::CorbaNaming &naming,string rtc_name){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif

	eclisti[(CORBA::ULong)0]->activate_component(rtc0);
	//eclisti[(CORBA::ULong)0]->activate_component(RTC::RTObject::_duplicate(rtc0._ptr()));
	return SIGNAL_TRUE;
}


//特定のRTコンポーネントを非アクティブ化する
int rtc_deactive(RTC::CorbaNaming &naming,string rtc_name){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif

	eclisti[(CORBA::ULong)0]->deactivate_component(rtc0);
	//	eclisti[(CORBA::ULong)0]->deactivate_component(RTC::RTObject::_duplicate(rtc0._ptr()));
	return SIGNAL_TRUE;
}



//特定のRTコンポーネントをリセットする
int rtc_reset(RTC::CorbaNaming &naming,string rtc_name){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif

	eclisti[(CORBA::ULong)0]->reset_component(rtc0);
	return SIGNAL_TRUE;
}

int rtc_config_get(RTC::CorbaNaming &naming,string in_name,string confset_name){
	string RTC_NAME=in_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

	RTC::Properties properties;
	RTC::NVList list;

	SDOPackage::Configuration_ptr conf = rtc0->get_configuration();
	SDOPackage::ConfigurationSet *confSet = conf->get_configuration_set(confset_name.c_str());
	cout<<"----------configuration----------"<<endl;
	NVUtil::dump(confSet->configuration_data);
	cout<<endl;
	cout<<endl;

	return SIGNAL_TRUE;
}

//コンフィグレーション値を変更する
int rtc_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value,string confset_name){
	string RTC_NAME=in_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

	RTC::Properties properties;
	RTC::NVList list;

	SDOPackage::Configuration_ptr conf = rtc0->get_configuration();
	SDOPackage::ConfigurationSet *confSet = conf->get_configuration_set(confset_name.c_str());

	NVUtil::copyToProperties(properties, confSet->configuration_data);
	properties.setProperty(key, value);

	NVUtil::copyFromProperties(list, properties);
	confSet->configuration_data = list;

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	conf->set_configuration_set_values(confset_name.c_str(),*confSet);
#else								//This Code for OpenRTM-1.0
	conf->set_configuration_set_values(*confSet);
#endif

	conf->activate_configuration_set(confset_name.c_str());

	return SIGNAL_TRUE;
}


//新しいコンフィグレーション値を設定する
int rtc_new_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value,string confset_name){

	string RTC_NAME=in_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

	RTC::Properties properties;
	RTC::NVList list;

	SDOPackage::Configuration_ptr conf = rtc0->get_configuration();
	SDOPackage::ConfigurationSet confSet;

	confSet.id = confset_name.c_str();
	confSet.description = "New Configuration Set";
	properties.setProperty(key, value);

	NVUtil::copyFromProperties(list, properties);
	confSet.configuration_data = list;

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	conf->set_configuration_set_values(confset_name.c_str(),confSet);
#else								//This Code for OpenRTM-1.0
	conf->set_configuration_set_values(confSet);
#endif

	conf->activate_configuration_set(confset_name.c_str());
	return SIGNAL_TRUE;
}


//defaultのコンフィグレーション値を変更する
int rtc_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value){
	rtc_config_set(naming,in_name,key,value,"default");
	return SIGNAL_TRUE;
}

//RTコンポーネントがネームサーバに存在するかどうか確認
int rtc_namecheck(string rtc_name,string rtclist[],int rtc_num){
	if(rtc_num==0) return SIGNAL_ERROR;

	for(int i=0;i<rtc_num;i++){
		if(rtc_name==rtclist[i]){
			return SIGNAL_TRUE;
		}
	}
	cout<<"Comp Name Error:  "<<rtc_name<<endl;
	cout<<"-----------Components List-----------"<<endl;
	for(int i=0;i<rtc_num;i++){
		cout<<rtclist[i]<<",";
	}
	cout<<endl;
	cout<<"-------------------------------------"<<endl;
	return SIGNAL_ERROR;
}

//RTコンポーネントのポート名一覧を出力
int rtc_port_namelist(RTC::CorbaNaming &naming,string rtc_name){

#ifdef WITH_ACE							//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::Port_ptr port;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortService_ptr port;
#endif
	cout<<rtc_name<<":"<<endl;
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

	portlist = rtc0->get_ports();
	for (CORBA::ULong i(0), n(portlist->length()); i < n; ++i){
		port = portlist[i];
		cout <<"  "<<i<<":"<<port->get_port_profile()->name<<endl;
	}

	return SIGNAL_TRUE;
}

//ネームサーバに登録されている全てのRTコンポーネントのポートの接続状態・接続先の一覧を出す．
int rtc_all_show(RTC::CorbaNaming &naming){
	//リスト取得
	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();

#ifdef WITH_ACE							//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		rtc_state(naming,rtclist[i]);
		rtc_portshow(naming,rtclist[i]);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		rtc_state(naming,rtclist[i]);
		rtc_portshow(naming,rtclist[i]);
		//	rtc_config_get(naming,rtclist[i],"default");
	}
#endif
	return SIGNAL_TRUE;
}
//ネームサーバに登録されている全てのRTコンポーネントのアクティブ化
int rtc_all_active(RTC::CorbaNaming &naming){
	////RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		rtc_active(naming,rtclist[i]);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		rtc_active(naming,rtclist[i]);
	}
#endif

	return SIGNAL_TRUE;
}

//ネームサーバに登録されている全てのRTコンポーネントの非アクティブ化
int rtc_all_deactive(RTC::CorbaNaming &naming){
	////RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		rtc_deactive(naming,rtclist[i]);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		rtc_deactive(naming,rtclist[i]);
	}
#endif
	return SIGNAL_TRUE;
}

//ネームサーバに登録されている全てのRTコンポーネントの接続解除
int rtc_all_disconnect(RTC::CorbaNaming &naming){
	////RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		rtc_disconnect(naming,rtclist[i]);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		rtc_disconnect(naming,rtclist[i]);
	}
#endif
	return SIGNAL_TRUE;
}


////ポートの接続状態・接続先の一覧を出す．
int ConnectionList(RTC::CorbaNaming &naming,string rtc_name,string comp_buff[],string port_buff[],int &con_num,string con_id[]){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif
	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();

	for (CORBA::ULong i(0); i < portlist->length(); i++)  {
		RTC::PortProfile_var pprofile;
		pprofile = portlist[i]->get_port_profile();
		RTC::ConnectorProfileList connector(pprofile->connector_profiles);

		if(connector.length()>0){
			for (CORBA::ULong j(0); j < connector.length(); ++j){
				comp_buff[con_num]=rtc_name;
				port_buff[con_num]=pprofile->name;
				con_id[con_num]=connector[j].connector_id;
				con_num++;
			}
		}
	}

	return SIGNAL_TRUE;
}



////ポートの接続状態・接続先の一覧を出す．
int ConnectionList(RTC::CorbaNaming &naming,string rtc_name,vector<string>& comp_buff
				   ,vector<string>& port_buff,int &con_num,vector<string>& con_id){

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
					   RTC::PortList_var portlist;
					   RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
					   RTC::PortServiceList_var portlist;
					   RTC::PortServiceList pl;
#endif
					   string RTC_NAME=rtc_name+".rtc";
					   CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
					   RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
					   portlist = rtc0->get_ports();

					   for (CORBA::ULong i(0); i < portlist->length(); i++)  {
						   RTC::PortProfile_var pprofile;
						   pprofile = portlist[i]->get_port_profile();
						   RTC::ConnectorProfileList connector(pprofile->connector_profiles);

						   if(connector.length()>0){
							   for (CORBA::ULong j(0); j < connector.length(); ++j){
								   comp_buff.push_back(rtc_name);

								   string ppname;
								   ppname=pprofile->name;
								   port_buff.push_back(ppname);

								   string id;
								   id=connector[j].connector_id;
								   con_id.push_back(id);
								   con_num++;
							   }
						   }
					   }

					   return SIGNAL_TRUE;
}


//Save
int rtc_connect_save(RTC::CorbaNaming &naming,string ipsdress,string fname){

	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();

	//一度コネクションリストをバッファに貯める．
	int connect_buff_num=0;
	vector<string> conID_buff,comp_buff,port_buff;


#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		ConnectionList(naming,rtclist[i],comp_buff,port_buff,connect_buff_num,conID_buff);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		ConnectionList(naming,rtclist[i],comp_buff,port_buff,connect_buff_num,conID_buff);
	}
#endif


	vector<string> incomp,inport,outcomp,outport,conID_list;
	int con_num=0;
	for(int i=0;i<connect_buff_num;i++){
		int ID_CHECK=0;
		for(int j=0;j<con_num;j++){//IDが一致するものを探す．
			if(conID_buff[i]==conID_list[j]){//一致したとき，	
				ID_CHECK=1;
				outcomp.push_back(comp_buff[i]);
				outport.push_back(port_buff[i]);

			}
		}
		if(ID_CHECK==0){//一致しないとき，
			conID_list.push_back(conID_buff[i]);
			incomp.push_back(comp_buff[i]);
			inport.push_back(port_buff[i]);
			con_num++;
		}
	}
	cout<<con_num<<endl;

	cout<<"ConnectionList"<<endl;
	for(int i=0;i<con_num;i++){
		cout<<ipsdress<<" ";
		cout<<incomp[i]<<" ";
		cout<<inport[i]<<" ";
		cout<<outcomp[i]<<" ";
		cout<<outport[i]<<endl;
	}

	/////////////////////////////////////////////////
	std::ofstream ofs;

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
	//windows RTC-Connection
	string out_win_file=fname+".bat";
	ofs.open( out_win_file.c_str() );
	ofs<<"@echo off"<<endl;
	for(int i=0;i<con_num;i++){
		ofs<<"rtc-controller.exe ";
		ofs<<ipsdress;
		ofs<<" --connect ";
		ofs<<incomp[i]<<" ";
		ofs<<inport[i]<<" ";
		ofs<<outcomp[i]<<" ";
		ofs<<outport[i]<<endl;
	}
	cout<<out_win_file<<" saved"<<endl;
	//Linux RTC-Connection
#else
	string out_linux_file=fname+".sh";
	ofs.open( out_linux_file.c_str() );
	ofs<<"#!/bin/sh"<<endl;
	for(int i=0;i<con_num;i++){
		ofs<<"rtc-controller ";
		ofs<<ipsdress;
		ofs<<" --connect ";
		ofs<<incomp[i]<<" ";
		ofs<<inport[i]<<" ";
		ofs<<outcomp[i]<<" ";
		ofs<<outport[i]<<endl;
	}
	cout<<out_linux_file<<" saved"<<endl;

#endif
	ofs.close();

	/////////////////////////////////////////////////

	return SIGNAL_TRUE;
}



int rtc_get_rate(RTC::CorbaNaming &naming,string rtc_name){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif

	double rate=eclisti[(CORBA::ULong)0]->get_rate();
	cout<<rtc_name<<" rate:"<<rate<<"Hz"<<endl;
	return SIGNAL_TRUE;
}

//ネームサーバに登録されている全てのRTコンポーネントのアクティブ化
int rtc_all_get_rate(RTC::CorbaNaming &naming){
	////RTコンポーネントリスト格納
	vector<string> rtclist;
	rtc_get_rtclist(naming,rtclist);
	int rtc_num=rtclist.size();


#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	for(int i=0;i<rtc_num;i++){
		rtc_get_rate(naming,rtclist[i]);
	}
#else								//This Code for OpenRTM-1.0
	//OpenRTM-1.0ではrtclist[0]はmanagerの為，rtclist[1]から
	for(int i=1;i<rtc_num;i++){
		rtc_get_rate(naming,rtclist[i]);
	}
#endif

	return SIGNAL_TRUE;
}

int rtc_set_rate(RTC::CorbaNaming &naming,string rtc_name,double helz){
	string RTC_NAME= rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::ExecutionContextServiceList_var eclisti;
	eclisti = rtc0->get_execution_context_services();
#else								//This Code for OpenRTM-1.0
	RTC::ExecutionContextList_var eclisti;
	eclisti = rtc0->get_owned_contexts();
#endif

	eclisti[(CORBA::ULong)0]->set_rate(helz);
	cout<<rtc_name<<"setrate:"<<helz<<endl;
	return SIGNAL_TRUE;
}

//ポートの接続状態・接続先の一覧を出す．
int rtc_get_portlist(RTC::CorbaNaming &naming,string rtc_name,vector<string> &portnames){
	portnames.clear();

#ifdef WITH_ACE						//This Code for OpenRTM-0.4.2
	RTC::PortList_var portlist;
	RTC::PortList pl;
#else								//This Code for OpenRTM-1.0
	RTC::PortServiceList_var portlist;
	RTC::PortServiceList pl;
#endif

	string RTC_NAME=rtc_name+".rtc";
	CORBA::Object_var cor_obj = naming.resolve(RTC_NAME.c_str());
	RTC::RTObject_var rtc0 = RTC::RTObject::_narrow(cor_obj);
	portlist = rtc0->get_ports();

	for (CORBA::ULong i(0); i < portlist->length(); i++)  {

		string pname;
		pname=portlist[i]->get_port_profile()->name;
		portnames.push_back(pname);
	}
	return SIGNAL_TRUE;
}




//loads
int rtc_connect_load(RTC::CorbaNaming &namingserver,string fname){

	rtc_all_disconnect(namingserver);

	std::ifstream ifs;
#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__)
	string inputfile=fname+".bat";
#else
	string inputfile=fname+".sh";
#endif
	ifs.open(inputfile.c_str());

	if (ifs.fail()) {
		std::cerr << "Error: Could not Open"<<endl;
		return SIGNAL_ERROR;
	}

	string buf;
	int line_num(0);

	vector<string> rtc_out;
	vector<string> port_out;
	vector<string> rtc_in;
	vector<string> port_in;
	while(ifs && getline(ifs, buf)) {
		if(line_num>0){
			vector<string> result = splitstr(buf, " ");
			rtc_out.push_back(result[3].c_str());	//rtc_out
			port_out.push_back(result[4].c_str());	//port_out
			rtc_in.push_back(result[5].c_str());	//rtc_in
			port_in.push_back(result[6].c_str());	//port_in
		}
		line_num++;
	}
	ifs.close();

	vector<string> rtclist;
	rtc_get_rtclist(namingserver,rtclist);

	for(int i=0;i<(signed)rtc_out.size();i++){
		string rtc_name1=rtc_in[i];
		string rtc_name2=rtc_out[i];
		string port_name1=port_in[i];
		string port_name2=port_out[i];
		cout<<"Connection: "<<rtc_name1<<":"<<port_name1<<"->"<<rtc_name2<<":"<<port_name2<<endl;
		int port_num1;
		int port_num2;

		if(!rtc_namecheck(rtc_name1,&rtclist[0],rtclist.size())
			&&(!rtc_namecheck(rtc_name2,&rtclist[0],rtclist.size())))	{
				vector<string> portlist1;
				rtc_get_portlist(namingserver,rtc_name1,portlist1);
				vector<string> portlist2;
				rtc_get_portlist(namingserver,rtc_name2,portlist2);

				if((!name_to_number(&portlist1[0],portlist1.size(),port_name1,port_num1))&&(!name_to_number(&portlist2[0],portlist2.size(),port_name2,port_num2)))
					rtc_connect(namingserver,rtc_name1,port_num1,rtc_name2,port_num2);
		}
		cout<<endl;
	}

	return SIGNAL_TRUE;
}


