// -*- C++ -*-
/*!
 * @file  MemleakBooleanSeqOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakBooleanSeqOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakbooleanseqout_spec[] =
  {
    "implementation_id", "MemleakBooleanSeqOut",
    "type_name",         "MemleakBooleanSeqOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakBooleanSeqOut::MemleakBooleanSeqOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataOut("data", m_data)

    // </rtc-template>
{
}

MemleakBooleanSeqOut::~MemleakBooleanSeqOut()
{
}


RTC::ReturnCode_t MemleakBooleanSeqOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("data", m_dataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakBooleanSeqOut::onExecute(RTC::UniqueId ec_id)
{
  m_data.data.length(2);
  m_data.data[0] = false;
  m_data.data[1] = true;
  m_dataOut.write();
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakBooleanSeqOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakbooleanseqout_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakBooleanSeqOut>,
                             RTC::Delete<MemleakBooleanSeqOut>);
  }
  
};



