// -*- C++ -*-
/*!
 * @file  MemleakFloatSeqOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakFloatSeqOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakfloatseqout_spec[] =
  {
    "implementation_id", "MemleakFloatSeqOut",
    "type_name",         "MemleakFloatSeqOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakFloatSeqOut::MemleakFloatSeqOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataOut("data", m_data)

    // </rtc-template>
{
}

MemleakFloatSeqOut::~MemleakFloatSeqOut()
{
}


RTC::ReturnCode_t MemleakFloatSeqOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("data", m_dataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakFloatSeqOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakFloatSeqOut::onExecute(RTC::UniqueId ec_id)
{
  m_data.data.length(2);
  m_data.data[0] = 55.5;
  m_data.data[1] = 555.55;
  m_dataOut.write();
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakFloatSeqOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakFloatSeqOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakfloatseqout_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakFloatSeqOut>,
                             RTC::Delete<MemleakFloatSeqOut>);
  }
  
};



