// -*- C++ -*-
/*!
 * @file  MemleakLongOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakLongOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleaklongout_spec[] =
  {
    "implementation_id", "MemleakLongOut",
    "type_name",         "MemleakLongOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakLongOut::MemleakLongOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataOut("data", m_data)

    // </rtc-template>
{
}

MemleakLongOut::~MemleakLongOut()
{
}


RTC::ReturnCode_t MemleakLongOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("data", m_dataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakLongOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakLongOut::onExecute(RTC::UniqueId ec_id)
{
  m_data.data = 1000;
  m_dataOut.write();
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakLongOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakLongOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleaklongout_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakLongOut>,
                             RTC::Delete<MemleakLongOut>);
  }
  
};



