// -*- C++ -*-
/*!
 * @file  MemleakLongSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakLongSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleaklongseqin_spec[] =
  {
    "implementation_id", "MemleakLongSeqIn",
    "type_name",         "MemleakLongSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakLongSeqIn::MemleakLongSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_longCnt = 0;
#endif
}

MemleakLongSeqIn::~MemleakLongSeqIn()
{
}


RTC::ReturnCode_t MemleakLongSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakLongSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakLongSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedLongSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
#ifdef __T_KERNEL__
      m_longCnt++;
      if(m_longCnt > 100)
      {
        printf("%d:%d\n", i, m_data.data[i]);
        m_longCnt = 0;
      }
#else
      printf("%d:%d\n", i, m_data.data[i]);
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakLongSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakLongSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleaklongseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakLongSeqIn>,
                             RTC::Delete<MemleakLongSeqIn>);
  }
  
};



