// -*- C++ -*-
/*!
 * @file  MemleakLongSeqOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakLongSeqOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleaklongseqout_spec[] =
  {
    "implementation_id", "MemleakLongSeqOut",
    "type_name",         "MemleakLongSeqOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakLongSeqOut::MemleakLongSeqOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataOut("data", m_data)

    // </rtc-template>
{
}

MemleakLongSeqOut::~MemleakLongSeqOut()
{
}


RTC::ReturnCode_t MemleakLongSeqOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("data", m_dataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakLongSeqOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakLongSeqOut::onExecute(RTC::UniqueId ec_id)
{
  m_data.data.length(2);
  m_data.data[0] = 1000;
  m_data.data[1] = 2000;
  m_dataOut.write();
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakLongSeqOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakLongSeqOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakLongSeqOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleaklongseqout_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakLongSeqOut>,
                             RTC::Delete<MemleakLongSeqOut>);
  }
  
};



