// -*- C++ -*-
/*!
 * @file  MemleakStringSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakStringSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakstringseqin_spec[] =
  {
    "implementation_id", "MemleakStringSeqIn",
    "type_name",         "MemleakStringSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakStringSeqIn::MemleakStringSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_stringCnt = 0;
#endif
}

MemleakStringSeqIn::~MemleakStringSeqIn()
{
}


RTC::ReturnCode_t MemleakStringSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakStringSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakStringSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedStringSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
#ifdef __T_KERNEL__
//DEL      m_stringCnt++;
//DEL      if(m_stringCnt > 100)
//DEL      {
        printf("%d:%s\n", i, m_data.data[i]);
//DEL        m_stringCnt = 0;
//DEL      }
#else
      printf("%d:%s\n", i, m_data.data[i]);
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakStringSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakStringSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakStringSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakstringseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakStringSeqIn>,
                             RTC::Delete<MemleakStringSeqIn>);
  }
  
};



