// -*- C++ -*-
/*!
 * @file  SampleStringSeqOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleStringSeqOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplestringseqout_spec[] =
  {
    "implementation_id", "SampleStringSeqOut",
    "type_name",         "SampleStringSeqOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleStringSeqOut::SampleStringSeqOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_StringSeqOut("StringSeq", m_StringSeq)

    // </rtc-template>
{
}

SampleStringSeqOut::~SampleStringSeqOut()
{
}


RTC::ReturnCode_t SampleStringSeqOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("StringSeq", m_StringSeqOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleStringSeqOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleStringSeqOut::onExecute(RTC::UniqueId ec_id)
{
  int i, maxsize;
  
  //TimedStringSeq
  m_StringSeq.data.length(2);
  m_StringSeq.data[0] = "test1";
  m_StringSeq.data[1] = "test2";
#ifndef __T_KERNEL__  
  m_StringSeqOut.write();
#endif  
  std::cout << "TimedStringSeq write" << std::endl;
  maxsize = m_StringSeq.data.length();
  for(i = 0; i < maxsize; i++)
  {
    std::cout << i << ":" << m_StringSeq.data[i] << std::endl;
  }
  std::cout << std::endl;
#ifdef __T_KERNEL__  
  m_StringSeqOut.write();
  sleep(5);
#endif  
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleStringSeqOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleStringSeqOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleStringSeqOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplestringseqout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleStringSeqOut>,
                             RTC::Delete<SampleStringSeqOut>);
  }
  
};



